#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <fcntl.h>

char *
my_itoa(int i)
{
  static char a[6];
  char * b=a+5;

  a[5]=0;
  do
    {
      b--;
      *b='0'+(i%10);
      i/=10;
    }
  while (i);
  return b;
}

/*
 * Spawns the program passed in the arguments and outputs its pid to the file
 * named in the last argument.
 */
int
main(int argc, char **argv)
{
  char *filename;
  int status;
  int pidfd;
  int pid;

  if (argc<3)
    {
      write(STDERR_FILENO, "Usage: pid <pid file> <prog name> [arguments]\n",
	    sizeof("Usage: pid <pid file> <prog name> [arguments]\n"));
      exit(1);
    }

  filename=(char *)malloc(strlen(argv[1]));
  strcpy(filename,argv[1]);

  *argv="/bin/sh";
  argv[1]="-c";

  if ((pid=fork())==0) /* we're the child */
    {
      execv(*argv, argv);
      write(STDERR_FILENO, "execv() failed.\n",
	    sizeof("execv() failed.\n"));
      exit(EXIT_FAILURE);
    }
  else
    {
      if ((pidfd=open(filename, O_WRONLY|O_CREAT))<0)
	{
	  write(STDERR_FILENO, "Could not open PID file ",
		sizeof("Could not open PID file "));
	  write(STDERR_FILENO, filename, strlen(filename));
	  write(STDERR_FILENO, "\n", 1);
	  exit(EXIT_FAILURE);
	}
      write(pidfd, my_itoa(pid), strlen(my_itoa(pid)));
      write(pidfd, "\n", 1);
      close(pidfd);
      wait(&status);
      exit(WEXITSTATUS(status));
    }
}
