/* tiny-login.h <ndf@linux.mit.edu> */

#define PROGRAM_NAME "login"
#define MAX_FAILURES 4
#define BUFFER_SIZE 1024
#define MOTD_FILE "/etc/motd"
#define TTY_MODE 0620
#define PW_PROMPT "Password: "

#define LOGIN_PROMPT "login: "

#define FAIL_MESSAGE "Login incorrect\n"

#define MAX_PW_LENGTH 15
#define MAX_USERNAME_LENGTH 10
#ifdef REMOTE
#define MAX_HOSTNAME_LENGTH 1024
#endif

struct settings {
  char username[MAX_USERNAME_LENGTH];
  char password[MAX_PW_LENGTH];
  int have_username;
  int verified;
  int num_failures;
};
  
#define DEFAULT_REMOTE_LOGIN 0
#define DEFAULT_FORCE 0
#define DEFAULT_HAVE_USERNAME 0









