/* tiny-getty.h <ndf@linux.mit.edu> */

#define DEFAULT_ISSUE    "/etc/issue"
#define DEFAULT_LOGIN    "/home/ndf/data/programming/tiny/login/tiny-login"
#define DEFAULT_PROMPT   "login: "
#define DEFAULT_SET_TERM 0
#define DEFAULT_TERM     "tty"
#define DEFAULT_BAUD     38400

#define TTY_OWNER 0 /* uid */
#define TTY_GROUP 5 /* gid */
#define TTY_MODE  0622

#define MAX_LINE_LENGTH 1024
#define PAGE_SIZE 1024

struct settings {
  char *tty;    /* Filename of the tty to use */
  char *login;  /* Full path to the login program */
  char *issue;  /* Full path to the issue file */
  int set_term; /* true if we should set the TERM environ variable */
  char *term;   /* string to which we should set the TERM environ var */
#ifdef SUPPORT_SERIAL
  int baud_rate; /* speed of the line */
#endif
};

#ifdef SUPPORT_SERIAL
struct speed {
  int baud_rate;
  int baud_const;
};

#define NUM_SPEEDS 15

struct speed speed[] = {
  50, B50,
  75, B75,
  110, B110,
  134, B134,
  150, B150,
  200, B200,
  300, B300,
  600, B600,
  1200, B1200,
  1800, B1800,
  2400, B2400,
  4800, B4800,
  9600, B9600,
  19200, B19200,
  38400, B38400};

#endif /* SUPPORT_SERIAL */

