/* tiny-login.h <ndf@linux.mit.edu> */

#define BUFFER_SIZE 1024
#define MOTD_FILE "/etc/motd"

#define PW_PROMPT "Password: "
#define PW_PROMPT_LENGTH 10

#define LOGIN_PROMPT "login: "
#define LOGIN_PROMPT_LENGTH 7

#define FAIL_MESSAGE "Login incorrect\n"
#define FAIL_MESSAGE_LENGTH 16

#define MAX_PW_LENGTH 15
#define MAX_USERNAME_LENGTH 10
#ifdef REMOTE
#define MAX_HOSTNAME_LENGTH 1024
#endif

struct settings {
  char username[MAX_USERNAME_LENGTH];
  char password[MAX_PW_LENGTH];
#ifdef REMOTE
  char hostname[MAX_HOSTNAME_LENGTH];
  struct hostent hostaddr;
  int remote_login;
#endif
#ifndef VERY_SMALL  
  int force;
#endif
  int have_username;
};
  

