/* tiny-cat.c <ndf@linux.mit.edu> */
#include <unistd.h>
#include <errno.h>
#include <string.h>
#include <sys/types.h>
#include <fcntl.h>
#include "tiny-cat.h"

char *filename;

int
report_error(void)
{
  char *error_string;
  error_string=strerror(errno);
  write(2, "cat: ", 5);
  write(2, filename, strlen(filename));
  write(2, ": ", 2);
  write(2, error_string, strlen(error_string));
  write(2, "\n", 1);
  exit(1);
}

int
open_file(char *new_filename)
{
  int fd;

  filename=new_filename;

  if (*filename=='-' && *(filename+1)=='\0')
    return(0); /* stdin */
  
  if ((fd=open(filename, O_RDONLY|O_NOCTTY))<0) /* open returned an error */
      report_error();

  return(fd);
}
  

int
output_file(int fd)
/* output this file until we reach EOF, then return */
{
  char buff[BUFFER_SIZE];
  int bytes_read; 

  while ((bytes_read=read(fd, buff, BUFFER_SIZE))>0)
    write(1, buff, bytes_read);

  if (bytes_read<0)
      report_error();

  return(1);
}

int
main (int argc, char **argv)
{
  /* File descriptor for the input file */
  int curr_input_fd;
  int arg_num;

  if (argc==1)
    arg_num=0;
  else
    arg_num=1;
  while(arg_num<argc)
    {
      if (argc==1)
	curr_input_fd=open_file("-");
      else
	curr_input_fd=open_file(argv[arg_num]);
      output_file(curr_input_fd);
      close(curr_input_fd);
      arg_num++;
    }

  close(1);
  
  return(0);
}
