/*
 *	Terminal subsystem (very sub for now)
 *
 *	This is the tty major number driver. We split it by the upper 3 bits
 *	into subhandlers.
 *
 *
 *	Not yet finished (or even compilable).
 */
 
#include <linuxmt/types.h>
#include <linuxmt/config.h>
#include <linuxmt/sched.h>
#include <linuxmt/fs.h>
#include <linuxmt/fcntl.h>
#include <linuxmt/errno.h>
#include <linuxmt/termios.h>
#include <linuxmt/clist.h>
#include <linuxmt/tty.h>
#include <linuxmt/major.h>

struct tty_handler
{
	int (*open)();
};

struct tty_handler ttyhandler[8];


int tty_open(inode,file)
struct inode *inode;
struct file *file;
{
	printk("Got this far!\n");
	int minor=MINOR(inode->i_rdev);
	if(!ttyhandler[minor>>5].open)
		return -ENXIO;
	return ttyhandler[minor>>5].open(inode,file);
}

void tty_release(inode,file)
struct inode *inode;
struct file *file;
{
	int minor=MINOR(inode->i_rdev);
	struct tty *tty=file->private_data;
	tty->ops->release(tty,inode,file);
}


/*
 *	Terminal output processor
 */
 
int tty_outchar(tty,ch)
struct tty *tty;
unsigned char ch;
{
	/*
	 *	Check for special operations
	 */
	if(O_OPOST(tty))
	{
		if(ch=='\n' && O_ONLCR(tty))
			ch='\r';
		else if(ch=='\r' && O_OCRNL(tty))
			ch='\n';
		else if(ch=='\r' && O_ONOCR(tty))
			return 0;
		/*
		 *	FIXME: ONLRET delays 
		 */
	}
	if(cl_addch(tty, &tty->outq,ch)<0)
		return -1;
	return 0;
}

/*
 *	Write to a terminal
 */
 
int tty_write(inode,file,data,len)
struct inode *inode;
struct file *file;
char *data;
int len;
{
	int minor=MINOR(inode->i_rdev);
	struct tty *tty=file->private_data;
	int ct=0;
	int err=0;
	while(ct<len)
	{
		unsigned char ch=*data++;
		if(tty->flags&TTY_CLOSED)
			return -EIO;
		if(tty->flags&TTY_STOPPED || !tty_outchar(tty,ch))
		{
			if(file->f_flags&O_NDELAY)
			{
				err=-EWOULDBLOCK;
				break;
			}
			tty->ops->kick(tty);
			interruptible_sleep_on(&tty->sleep);
			if(current->signal & ~current->blocked)
			{
				err=-EINTR;
				break;
			}
		}
		ct++;
	}			
	tty->ops->kick(tty);
	if(ct)
		return ct;
	return err;
}

static int tty_delchar(tty, c)
struct tty *tty;
unsigned char c;
{
	int ct=1;
	int i;	
	if(c<32)
		ct=2;
		
	for(i=0;i<ct;i++)
	{
		tty_outchar(tty,8);
		tty_outchar(tty,' ');
		tty_outchar(tty,8);
		tty->ops->kick(tty);
	}
}

int tty_read(inode,file,data,len)
struct inode *inode;
struct file *file;
char *data;
int len;
{
	unsigned char c;
	int minor=MINOR(inode->i_rdev);
	struct tty *tty=file->private_data;
	int ct=0;
	int err=0;
	
	while(ct<len)
	{
		int v;
		if(tty->flags&TTY_CLOSED)
		{
			err=-EIO;
			break;
		}
		v=cl_getch(&tty->inq);
		if(v<0)
		{
			if(file->f_flags&O_NDELAY)
			{
				err=-EWOULDBLOCK;
				break;
			}
			interruptible_sleep_on(&tty->sleep);
			if(current->signal&~current->blocked)
			{
				err=-EINTR;
				break;
			}
		}
		if(I_IGNCR(tty) && c=='\r')
			continue;
		if(I_INLCR(tty) && c=='\n')
			c='\r';
		else if(I_ICRNL(tty) && c=='\r')
			c='\n';
		
		if(L_ICANON(tty))
		{
			if(ERASE_CHAR(tty) && ERASE_CHAR(tty)==c)
			{
				if(ct>0)
				{
					data--;
					ct--;
					if(L_ECHOE(tty))
						tty_delchar(tty,*data);
				}
			}
			if(KILL_CHAR(tty) && KILL_CHAR(tty)==c)
			{
				data-=ct;
				ct=0;
				if(L_ECHOK(tty))
				{
					tty_outchar(tty,'\n');
					tty->ops->kick(tty);
				}	
			}
			if(EOF_CHAR(tty) && EOF_CHAR(tty)==c)
			{
				err=0;
				break;
			}
			/*
			 *	Signals, flush, etc
			 */
			if(L_ECHO(tty))
			{
				if(c>31)
					tty_outchar(tty,c);
				else
				{
					tty_outchar(tty,'^');
					tty_outchar(tty,c+64);
				}
				tty->ops->kick(tty);				
			}
		}
		*data++=c;
		ct++;
	}
	if(ct>0)
		return ct;
	return err;
}

int tty_ioctl(inode,file, cmd, arg)
struct inode *inode;
struct file *file;
int cmd;
char *arg;
{
	return -EINVAL;
}

int tty_lseek(inode,file,offset,origin)
struct inode *inode;
struct file *file;
off_t offset;
int origin;
{
	return -ESPIPE;
}

int tty_readdir()
{
	return -ENOTDIR;
}

static struct file_operations tty_fops =
{
	tty_lseek,
	tty_read,
	tty_write,
	tty_readdir,
	NULL,		/* Select - needs doing */
	tty_ioctl,
	tty_open,
	tty_release,
	NULL,
	NULL,
	NULL
};

void tty_init()
{
	register_chrdev(TTY_MAJOR,"tty",&tty_fops);
}
	
