#include <linuxmt/types.h>
#include <linuxmt/clist.h>
#include <linuxmt/tty.h>

struct clist cl_array[NUM_CLIST];
struct clist *cl_freelist;
int num_clfree=NUM_CLIST;

struct clist *cl_alloc()
{
	struct clist *tmp=cl_freelist;
	if(cl_freelist!=NULL)
	{
		cl_freelist=tmp->cl_next;
		tmp->cl_head=0;
		tmp->cl_tail=0;
		tmp->cl_next=NULL;
		num_clfree--;
	}
	return tmp;
}

void cl_free(cl)
struct clist *cl;
{
	cl->cl_next=cl_freelist;
	cl_freelist=cl;
	num_clfree++;
}

int cl_addch(tty,ch,c)
struct tty *tty;
struct clhead *ch;
unsigned char c;
{
	struct clist *cl=ch->ch_tail;
	if(cl==NULL||cl->cl_tail==CL_NCHAR)
	{
		if(ch->ch_count==ch->ch_limit)
			return -1;
		cl=cl_alloc();
		if(!cl)
			return -1;
		ch->ch_count++;
		if(!ch->ch_head)
			ch->ch_head=cl;
		else
			ch->ch_tail->cl_next=cl;
		ch->ch_tail=cl;
	}
	cl->cl_data[cl->cl_tail++]=c;
	wake_up(&tty->sleep);
	return 0;
}

int cl_getch(ch)
struct clhead *ch;
{
	unsigned char c;
	struct clist *cl=ch->ch_head;
	if(cl==NULL)
		return -1;
	c=cl->cl_data[cl->cl_head++];
	if(cl->cl_head==cl->cl_tail)
	{
		ch->ch_head=cl->cl_next;
		if(ch->ch_head==NULL)
			ch->ch_tail=NULL;
		ch->ch_count--;
		cl_free(cl);
	}
	return c;
}

void cl_empty(ch)
struct clhead *ch;
{
	while(cl_getch(ch)!=-1);
}

int cl_delch(ch)
struct clhead *ch;
{
	unsigned char c;
	struct clist *cl=ch->ch_head;
	if(!cl)
		return -1;
	c=cl->cl_data[cl->cl_tail--];
	if(cl->cl_tail==cl->cl_head)
	{
		/*
		 *	Hard case
		 */
		 struct clist *cw;
		 if(cl==ch->ch_head)
		 {
		 	ch->ch_head=NULL;
		 	ch->ch_tail=NULL;
		 }
		 else
		 {
		 	for(cw=ch->ch_head;cw->cl_next!=cl;cw=cw->cl_next);
		 	ch->ch_tail=cw;
		 	cw->cl_next=NULL;
		 }
		 cl_free(cl);
		 ch->ch_count--;
	}
	return c;
}

void cl_init()
{
	struct clist *cl=&cl_array[0];
	int i;
	for(i=0;i<NUM_CLIST-1;i++)
	{
		cl->cl_next=&cl[1];
		cl++;
	}
	cl->cl_next=NULL;
	printk("%d clists (%d bytes) allocated for terminals.\n",
		NUM_CLIST, NUM_CLIST*sizeof(struct clist));
}
