
#include <linuxmt/types.h>
#include <arch/io.h>
#include <arch/keyboard.h>
#include<linuxmt/errno.h>
#include<linuxmt/fs.h>
#include<linuxmt/fcntl.h>
#include<linuxmt/config.h>

#define ESC 27
#define KB_SIZE 64

/* XT keyboard state info */

#define LSHIFT 1
#define RSHIFT 2
#define CTRL 4
#define ALT 8
#define CAPS 16
#define NUM 32

#define ANYSHIFT 3 /* [LR]SHIFT */

extern struct wait_queue keywait;
static int newkey; /* AX from int 0x16/00h */ 

struct tty * _curvc_tty;
struct clhead * _curvc_ch;

int AddQueue();
int GetQueue();
int KeyboardInit();

int KeyboardInit()
{
   printk( "Keyboard buffer %d B\n", KB_SIZE );
}

/* These calls only modify AX, so hopefully we can encapsulate them safely */

unsigned int bios_querykey()
{
#asm
	mov ah, #1
	int #0x16
	jz key
	mov ax, #0
	ret
key:
	mov ax, #0
	ret
#endasm
}

unsigned int bios_getkey()
{
#asm
	xor ax, ax
	int #0x16
	ret
#endasm
}

unsigned char bios_getkeyflag()
{
#asm
	mov ah, #2
	int #0x16
	xor ah, ah
#endasm
}

/*
 * This is currently disabled! 
 */

void keyboard_irq(irq,regs)
int irq;
struct pt_regs *regs;
{
	int newkey, newflags;

	wake_up(&keywait);
}

/* Stubs for now */

void xtk_init()
{
}

int wait_for_keypress()
{
	bios_getkey();
}
