/*
 *	Moronic BIOS console
 */

#include <linuxmt/types.h>
#include <linuxmt/config.h>
#include <linuxmt/errno.h>
#include <linuxmt/fcntl.h>
#include <linuxmt/fs.h>
#include <linuxmt/major.h>
#include <linuxmt/sched.h>

#ifdef CONFIG_CONSOLE_BIOS 

int keyboard_read();

void con_charout(c)
char c;
{
	char tmp=c;
	/* Page 0 attribute 7 write character */

	/* \n\r handling */
	if (c == '\n') con_charout('\r');
#asm
	mov bx,#0x7
	mov ah,#0xe
	int 0x10
#endasm
}

int bioscon_lseek(inode,file,offset,origin)
struct inode *inode;
struct file *file;
off_t offset;
int origin;
{
	return -ESPIPE;
}

int bioscon_write(inode,file,buf,count)
struct inode *inode;
struct file *file;
char *buf;
int count;
{
	int len=0;
	for (len = 0; len < count; len++)	
	{
		con_charout(peekb(current->t_regs.ds, buf++));
	}
	return len;
}

void bioscon_release(inode,file)
struct inode *inode;
struct file *file;
{
	return;
}

int bioscon_open(inode,file)
struct inode *inode;
struct file *file;
{
	int minor = MINOR(inode->i_rdev);
	printk("BIOSCON: open %d\n", minor);
	if(minor!=0)
		return -ENODEV;
	return 0;
}


static struct file_operations bioscon_ops=
{
	bioscon_lseek,
	keyboard_read,
	bioscon_write,
	NULL,
	NULL,			/* Write select later */
	NULL,			/* Write ioctl later */
	bioscon_open,		/* Open the bios console */
	bioscon_release,	/* Close the bios console */
	NULL,			/* Fsync */
	NULL,			/* No media */
	NULL			/* No media */
};

void init_console()
{
	printk("Console: BIOS(%dx%d)\n",
		setupb(7),setupb(14));
	register_chrdev(TTY_MAJOR, "bioscon", &bioscon_ops);
}

#endif
