/* biosfd.c
 * (C) 1997 Chad Page
 *
 * This is a new BIOS-based floppy driver which may prove somewhat more 
 * reliable than the original doshd driver, and somewhat smaller too :)
 */

/* Some of this stuff should go to biosfd.h in include/arch... */

struct disktype {
	__u16 ntracks;
	__u8 nsectors;
	__u8 nsides;
};

/* This table contains all common disk capacities */
struct disktype fmt_table[] = {
	{0, 0, 0},	/* /dev/fdx - auto detect (when implemented) */
	{40, 8, 1},	/* /dev/fdxD160 */
	{40, 9, 1},	/* " D180 */
	{40, 8, 2},	/* D320 */
	{40, 9, 2},	/* D360 */
	{80, 9, 1},	/* A360(?) - used mostly on atari ST's */
	{80, 9, 2},	/* D720 */
	{80, 15, 2},	/* H1200 */
	{80, 18, 2},	/* H1440 */
	{80, 36, 2}, 	/* H2880 */
/* Now for some not-so-common ones :) */
	{40, 10, 2},	/* D400 */
	{80, 20, 2},	/* H1680 */
};


