#include <linuxmt/types.h>
#include <stdio.h>
#include <unistd.h>

struct exec_struct {
	char tty_name[10];
	pid_t pid;	
};

#define NUM_TTYS 3

struct exec_struct tty_list[] = {
	{"/dev/tty", 0},
	{"/dev/tty2", 0},
	{"/dev/tty3", 0}
};

int determine_tty(pid)
int pid;
{
	int i;
	for (i = 0; i < NUM_TTYS; i++) {
		if (pid == tty_list[i].pid) return i;
	}
	return -1;
}

int spawn_tty(num, argv)
int num;
char ** argv;
{
	int pid, fd, i;

	if ((pid = fork()) != 0) {
		tty_list[num].pid = pid;
		return pid;
	}
	if ((num < 0) || (num >= NUM_TTYS))
		exit();
	close(0);
	close(1);
	close(2);
	if ((fd = open(tty_list[num].tty_name, 2)) < 0) 
		exit();
	dup2(fd, 0);
	dup2(fd, 1);
	dup2(fd, 2);
	execv("/bin/login", argv);		
	exit();	
}

void main(argc,argv)
int argc;
char ** argv;
{
	int error, i, pid, fd;

	for (i = 0; i < NUM_TTYS; i++)
		spawn_tty(i, argv);

	fd = open("/dev/tty", 2);
	dup2(fd, 0);
	dup2(fd, 1);
	dup2(fd, 2);
	fflush(stdout);
	printf("PID of init is %d\n",getpid());

	while(1) {
		pid = wait(NULL);
/*		printf("pid #%d returned\n", pid);
*/		i = determine_tty(pid);
/*		printf("respawning tty #%d\n", i); 
		fflush(stdout);
*/		tty_list[i].pid = 0;
		spawn_tty(i, argv);
	}
}
