/*
 * Copyright (c) 1993 by David I. Bell
 * Permission is granted to use, distribute, or modify this source,
 * provided that this copyright notice remains intact.
 *
 * Most simple built-in commands are here.
 */

#include "../sash.h"

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <fcntl.h>
#include <signal.h>
#include <pwd.h>
#include <grp.h>
#include <utime.h>
#include <errno.h>

void
main(argc, argv)
	char	**argv;
{
	char		*name;
	int		fd;
	struct	utimbuf	now;

	time(&now.actime);
	now.modtime = now.actime;

	while (argc-- > 1) {
		name = *(++argv);

		fd = open(name, O_CREAT | O_WRONLY | O_EXCL, 0666);
		if (fd >= 0) {
			close(fd);
			continue;
		}

		if (utime(name, &now) < 0)
			perror(name);
	}
}
