/*
 * 	kernel/sched.c
 * 	(C) 1995 Chad Page 
 *	
 *	This is the main scheduler - hopefully simpler than Linux's at present.
 * 
 * 	We need to implement run-queues RSN, but first we just have to make
 * 	it *work*.  Of course, writing it would be a good start :)
 *
 */

#include <linuxmt/types.h>
#include <linuxmt/sched.h>
#include <arch/irq.h>

__ptask current, next;

extern struct wait_queue keywait;	/* For polled keyboard handling */
extern unsigned char can_tswitch; 
extern int lastirq;

int need_resched = 0;
#if 0
/* This is a diagnostic dump of all currently running tasks... to be run after
 * fork() for now.  Not very intelligible yet */
void print_tasks()
{
	int i;
	__ptask pt;
	printk("# pid state ds\n");
	for (i = 0; i < MAX_TASKS; i++) {
		pt = &task[i];
		printk("%d %d %d %x %x\n", i, pt->pid, pt->state, pt->t_regs.cs, pt->t_regs.ds); 
	}
}
#endif
/*
 *	Schedule a task. On entry current is the task, which will
 *	vanish quietly for a while and someone elses thread will return
 *	from here.
 */

void schedule()
{
	__uint maxpri; 
	__uint c, maxproc; 
	__ptask pt; 	/* Subscript calculation is *very* expensive in bcc */
	unsigned long flags;

	if (current->t_kstackm != KSTACK_MAGIC)
	    panic("Process %d exceeded kernel stack limit! magic %x\n", current->pid, current->t_kstackm);

	/* We have to let a task exit! */
	if (current->state == TASK_EXITING)
		return;

	maxproc = maxpri = 0;
	need_resched = 0;
	
	for (pt = current+1; pt != current; pt++) {
		if (pt == &task[MAX_TASKS])
			pt = &task[1];
		if (pt->state == TASK_RUNNING)
			break;
	}
	if (pt->state != TASK_RUNNING)
		pt = &task[0];
	if (pt != current) {
		save_regs();
		if ((!can_tswitch) && (lastirq != -1)) 
			printk("Warning, switching in interrupt %d - %d %d\n", lastirq, current->pid, pt->pid);
		current = pt;
		load_regs();	/* Returns to our caller */
	}
}

