/*
 *	This is NOT stunningly portable, but works
 *	for pretty dumb non ANSI compilers and is
 *	tight.	Adjust the sizes to taste.
 *
 *	Illegal format strings will break it. Only the
 *	following simple subset is supported
 *
 *	%x	-	hex
 *	%d	-	decimal
 *	%s	-	string
 *	%c	-	char
 *
 *	And the h/l length specifiers for %d/%x
 *
 *		Alan Cox.
 *
 *	MTK:	Sep 97 - Misc hacks to shrink generated code
 */

#include <linuxmt/types.h>
#include <linuxmt/fcntl.h>
#include <linuxmt/sched.h>

/*
 *	Just to make it work for now
 */
 
int cur_console = 0; 

extern void con_charout();

static void con_write(con,buf,len,flag)
int con;
char *buf;
int len;
int flag;
{
	char c;
	while (len) {
		c = *buf;
		if (c == '\n')
			con_charout('\r');	
		con_charout(c);
		len--;
		buf++;
	}
}
 
/************************************************************************/

/*
 *	Output a number
 */

static char *nstring="0123456789ABCDEF";
 
static void numout(ptr,len,base)
unsigned long *ptr;
int len;
int base;
{
	unsigned long v;
	int c;
	char buf[9];	/* Largest value must fit in this */
	char *bp=buf+7;
	bp[1]=0;

	v=*ptr;	
	if(len == 2)
		v = (unsigned short)v;

	do {
		c=v%base;			/* This digit */
		*bp=nstring[c];			/* String for it */
		v/=base;			/* Slide along */
		bp--;
	} while(v);
	
	bp++;
	con_write(cur_console,bp,buf-bp+sizeof(buf)-1,O_NDELAY);
}

void printk(fmt,a1)
char *fmt;
int a1;
{
	unsigned char *p=(char *)&a1;
	char c, tmp;

	while(c=*fmt++) {
		if(c!='%')
			con_write(cur_console,fmt-1,1,O_NDELAY);
		else {
			int len=2;
			c=*fmt++;
			if(c=='h')
				c=*fmt++;
			else if(c=='l') {
				len=4;
				c=*fmt++;
			}
			
			switch(c)				
			{
				case 'x': case 'p': case 'd':
					numout(p,len, (c == 'd') ? 10:16);
					p+=len;
					break;
				case 's':
				{
					char *cp=*((char **)p);
					p+=sizeof(char*);
					while(*cp)
						con_write(cur_console,cp++,1,O_NDELAY);
					break;
				}
				case 't':
				{
					char * cp=*((char **)p);
					p+=sizeof(char *);
					while ((tmp = get_fs_byte(cp))) {
						con_charout(tmp);
						cp++;
					}
					break;
				}
				case 'c':
					con_write(cur_console,p,1,O_NDELAY);
					p+=2;
					break;
				default:
					con_write(cur_console,"?",1,O_NDELAY);
			}
		}
	}
}

void panic(error,a1,a2,a3,a4)
char *error;
int a1,a2,a3,a4;	/* VARARGS.. */
{
	printk("panic: ");
	printk(error,a1,a2,a3,a4);
	while(1);
}
