/*
 *  linux/fs/ioctl.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

#include <linuxmt/types.h>
#include <arch/segment.h>
#include <linuxmt/sched.h>
#include <linuxmt/mm.h>
#include <linuxmt/errno.h>
#include <linuxmt/string.h>
#include <linuxmt/stat.h>
#include <linuxmt/termios.h>
#include <linuxmt/fcntl.h> /* for f_flags values */

/* temporary until linuxmt/types.h fixed */
#define FD_SET(fd,bits) (*(bits)|=(1<<(fd)))
#define FD_CLR(fd,bits) (*(bits)&=~(1<<(fd)))

static int file_ioctl(filp,cmd,arg)
struct file *filp;
unsigned int cmd;
unsigned int arg;
{
	int error;
	int block;

	switch (cmd) {
		case FIONREAD:
			error = verify_area(VERIFY_WRITE,(char *) arg,sizeof(long));
			if (error)
				return error;
			put_fs_long(filp->f_inode->i_size - filp->f_pos,
			    (long *) arg);
			return 0;
	}
	if (filp->f_op && filp->f_op->ioctl)
		return filp->f_op->ioctl(filp->f_inode, filp, cmd, arg);
	return -EINVAL;
}


int sys_ioctl(fd,cmd,arg)
unsigned int fd;
unsigned int cmd;
unsigned int arg;
{	
/*	unsigned long arg = get_fs_long(parg); */
	struct file * filp;
	int on;

	if (fd >= NR_OPEN || !(filp = current->files.fd[fd]))
		return -EBADF;
	switch (cmd) {
		case FIOCLEX:
			FD_SET(fd, &current->files.close_on_exec);
			return 0;

		case FIONCLEX:
			FD_CLR(fd, &current->files.close_on_exec);
			return 0;

		case FIONBIO:
			on = get_fs_word((unsigned int *) arg);
			if (on)
				filp->f_flags |= O_NONBLOCK;
			else
				filp->f_flags &= ~O_NONBLOCK;
			return 0;

		default:
			if (filp->f_inode && S_ISREG(filp->f_inode->i_mode))
				return file_ioctl(filp, cmd, arg);

			if (filp->f_op && filp->f_op->ioctl)
				return filp->f_op->ioctl(filp->f_inode, filp, cmd, arg);

			return -EINVAL;
	}
}
