#include <arch/bitops.h>
#include <arch/irq.h>
#include <linuxmt/kernel.h>

unsigned long bit_masks[] = 
	{1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 
  	32768, 65536, 131072, 262144, 524288, 1048576, 2097152, 4194304, 
	8388608, 16777216, 33554432, 67108864, 134217728, 268435456,  
	536870912, 1073741824, 2147483648};

/*
 *	Messy as we lack atomic bit operations on an 8086.
 */
 
int clear_bit(bit,addr)
int bit;
unsigned char *addr;
{
	int flags;
	int offset = (bit / 8);
	unsigned int r;
	bit%=8;
	save_flags(flags);
	cli();
	r=(addr[offset]&&(1<<bit));
	addr[offset] ^= r;	/* xor bit with itself is 0 */
	restore_flags(flags);
/*	if(r)
		return 1;
	return r; */
	return (r ? 1:0);
}

int set_bit(nr,addr)
int nr;
unsigned int *addr;
{
	unsigned int mask, retval, offset;
	int i;

	cli();
	retval = test_bit(nr, addr);
	sti();
	if (retval) 
		return 1;
	else 
	{		
		offset = nr / 16;	
		mask = bit_masks[nr % 16];
		addr[offset] += mask;
		if (!test_bit(nr, addr)) panic("set_bit failed! %d\n", mask);
		return 0;
	}
}

#ifdef USE_C
int test_bit(bit,addr)
int bit;
unsigned int *addr;
{
	unsigned int mask;
	int offset;
	int i;
	offset = (bit / 16);
	mask = bit_masks[bit % 16];
	return ((mask & addr[offset] ) != 0);
}
#else
#asm
	.globl _test_bit
	.text
	.even
_test_bit:
	push bp
	mov bp,sp

	mov cx,[bp+4]
	mov bx,cx
	and cl,#7
	shr bx,#3
	add bx,[bp+6]

	mov al,[bx]
	shr ax,cl
	and ax,#1

	pop bp
	ret
#endasm
#endif

/* Ack... nobody even seemed to try to write to a file before 0.0.49a was
 * released, or otherwise they might have tracked it down to this being
 * non-existant :) 
 * - Chad
 */
#ifndef USE_NEW /* Old slow, small version */
int find_first_zero_bit(addr, len)
unsigned long *addr;
int len;
{
	unsigned int i;

	for (i = 0; i < len; i++) {
		if (!test_bit(i, addr)) {
			return i;
		}
	}	
	return len;
}
#else /* New fast big version (93 bytes bigger) */
int find_first_zero_bit(addr, len)
unsigned long *addr;
int len;
{
	unsigned int *ip = (unsigned int*)addr;
	unsigned int iw;
	unsigned int ib;
	unsigned int im;

	for(iw = 0; iw <= (len / 16); iw++, ip++) {
		if(*ip != UINT_MAX) {
			for(ib=0, im=1; ib<16; ib++, im <<= 1) {
				if (!(*ip & im)) {
					iw = (iw * 16) + ib;
					return (iw > len) ? len : iw;
				}
			}
		}
	}

	return len;
}
#endif
