/*
 *	Tables from the Minix book, as thats all I have on XT keyboard controllers
 *	They need be loadable, this doesn't look good on my finnish kbd.
 */

/***************************************************************
 * Added primitive buffering, and function stubs for vfs calls *
 * Removed vfs funcs, they belong better to the console driver *
 * Saku Airila 1996                                            *
 ***************************************************************/

#include <linuxmt/sched.h>
#include <linuxmt/types.h>
#include <arch/io.h>
#include <arch/keyboard.h>
#include<linuxmt/errno.h>
#include<linuxmt/fs.h>
#include<linuxmt/fcntl.h>
#include<linuxmt/config.h>
#include<linuxmt/chqueue.h>
#include<linuxmt/ntty.h>

extern struct tty ttys[];

#define ESC 27
#define KB_SIZE 64
#define USE_DEFAULT_KEYMAP y

#ifdef USE_DEFAULT_KEYMAP
static unsigned char xtkb_scan[]=
{
	0,033,'1','2','3','4','5','6',
	'7','8','9','0','-','=','\b','\t',
	'q','w','e','r','t','y','u','i',
	'o','p','[',']',015,0202,'a','s',
	'd','f','g','h','j','k','l',';',
	'\'',0140,0200,0134,'z','x','c','v',
	'b','n','m',',','.','/',0201,'*',
	0203,' ',0204,0241,0242,0243,0244,0245,
	0246,0247,0250,0251,0252,0205,0210,0267,
	0270,0271,0211,0264,0265,0266,0214,0261,
	0262,0263,'O',0177
};

static unsigned char xtkb_scan_shifted[]=
{
	0,033,'!','@','#','$','%','^',
	'&','*','(',')','_','+','\b','\t',
	'Q','W','E','R','T','Y','U','I',
	'O','P','{','}',015,0202,'A','S',
	'D','F','G','H','J','K','L',':',
	042,'~',0200,'|','Z','X','C','V',
	'B','N','M','<','>','?',0201,'*',
	0203,' ',0204,0221,0222,0223,0224,0225,
	0226,0227,0230,0231,0232,0204,0213,'7',
	'8','9',0211,'4','5','6',0214,'1',
	'2','3','0',0177
};

/*********************************
 * Quick add. Probably not good. *
 * SA                            *
 *********************************/

static unsigned char xtkb_scan_caps[]=
{
	0,033,'1','2','3','4','5','6',
	'7','8','9','0','-','=','\b','\t',
	'Q','W','E','R','T','Y','U','I',
	'O','P','[',']',015,0202,'A','S',
	'D','F','G','H','J','K','L',':',
	042,'~',0200,'|','Z','X','C','V',
	'B','N','M',',','.','/',0201,'*',
	0203,' ',0204,0221,0222,0223,0224,0225,
	0226,0227,0230,0231,0232,0204,0213,'7',
	'8','9',0211,'4','5','6',0214,'1',
	'2','3','0',0177
};
#else
#  include"keymap.h"
#endif /* USE_DEFAULT_KEYMAP */

/*
 *	Keyboard state - the poor little keyboard controller hasnt
 *	got the brains to remember itself.
 */
/*********************************************
 * Changed this a lot. Made it work, too. ;) *
 * SA 1996                                   *
 *********************************************/
#define LSHIFT 1
#define RSHIFT 2
#define CTRL 4
#define ALT 8
#define CAPS 16
#define NUM 32

#define ANYSHIFT 3 /* [LR]SHIFT */

static unsigned ModeState = 0;
static int E0Prefix = 0;

/****************************************************
 * Queue for input received but not yet read by the *
 * application.                                     *
 * SA 1996                                          *
 * There needs to be many buffers if we implement   *
 * virtual consoles...                              *
 ****************************************************/

static void SetLeds();

int AddQueue();
int GetQueue();
int KeyboardInit();

/* Not for long... */
void xtk_init()
{
   KeyboardInit();
}

int KeyboardInit()
{
}

/*
 *	XT style keyboard I/O is almost civilised compared
 *	with the monstrosity AT keyboards became.
 */
 
void keyboard_irq(irq,regs)
int irq;
struct pt_regs *regs;
{
int code;
int mode;
int IsRelease;
int key;
int E0 = 0;

extern int key_pressed;

   code=inb_p(KBD_IO);
   mode=inb_p(KBD_CTL);
   outb_p(mode | 0x80,KBD_CTL);  /* Necessary for the XT. */
   outb_p(mode,KBD_CTL);

   if( code == 0xE0 ) /* Remember this has been received */
   {
      E0Prefix = 1;
      return;
   }
   if( E0Prefix )
   {
      E0 = 1;
      E0Prefix = 0;
   }
   IsRelease = code & 0x80;
   switch( code & 0x7F )
   {
      case 29 :
         IsRelease ? ( ModeState &= ~CTRL ) : ( ModeState |= CTRL );
         return;
      case 42 :
         IsRelease ? ( ModeState &= ~LSHIFT ) : ( ModeState |= LSHIFT );
         return;
      case 54 :
         IsRelease ? ( ModeState &= ~RSHIFT ) : ( ModeState |= RSHIFT );
         return;
      case 56 :
         IsRelease ? ( ModeState &= ~ALT ) : ( ModeState |= ALT );
         return;
      case 58 :
         ModeState ^= IsRelease ? 0 : CAPS;
         return;
      case 69 :
         ModeState ^= IsRelease ? 0 : NUM;
         return;
      default :
         if( IsRelease )
            return;
         break;
   }

/*	Handle CTRL-ALT-DEL	*/

   if ((code == 0x53) && (ModeState & CTRL) && (ModeState & ALT))
	ctrl_alt_del();

/*
 *	Pick the right keymap
 */
   if( ModeState & CAPS && !( ModeState & ANYSHIFT ) )
      key = xtkb_scan_caps[ code ];
   else if( ModeState & ANYSHIFT && !( ModeState & CAPS ) )
      key = xtkb_scan_shifted[ code ];
   else
      key = xtkb_scan[ code ];
   if( ModeState & CTRL && code < 14)
      key = xtkb_scan_shifted[ code ];
   if( code < 70 && ModeState & NUM )
      key = xtkb_scan_shifted[ code ];
/*
 *	Apply special modifiers
 */
   if( ModeState & ALT ) 
      key |= 0x80; /* META-.. */
   if( !key ) /* non meta-@ is 64 */
      key = '@';
   if( ModeState & CTRL )
      key &= 0x1F; /* CTRL-.. */
   if( code < 0x45 && code > 0x3A ) /* F1 .. F10 */
   {
#ifdef CONFIG_CONSOLE_DIRECT
      if( ModeState & ALT )
      {
         Console_set_vc( code - 0x3B );
         return;
      }
#endif
      AddQueue( ESC );
      AddQueue( code - 0x3B + 'a' );
      return;
   }
   if( E0 ) /* Is extended scancode */
      switch( code )
      {
         case 0x48 :  /* Arrow up */
            AddQueue( ESC );
            AddQueue( 'A' );
            return;
         case 0x50 :  /* Arrow down */
            AddQueue( ESC );
            AddQueue( 'B' );
            return;
         case 0x4D :  /* Arrow right */
            AddQueue( ESC );
            AddQueue( 'C' );
            return;
         case 0x4B :  /* Arrow left */
            AddQueue( ESC );
            AddQueue( 'D' );
            return;
         case 0x1c :  /* keypad enter */
            AddQueue( '\n' );
            return;
      }
/*
 *   key_pressed is no longer needed... GetQueue returns -1 if there's
 *   nothing available. SA
 *   Flag for init.
 */	
   if (key == '\r') key = '\n';
   AddQueue( key_pressed = key );
}

/* Ack.  We can't add a character until the queue's ready */

int Current_VCminor = 0;

int AddQueue( Key )
unsigned char Key;
{
   if (ttys[Current_VCminor].inq.size != 0) {
	   chq_addch(&ttys[Current_VCminor].inq, Key, 0);
   }
   return 0;
}
#if 0
int GetQueue()
{
   return chq_getch(&ttys[0].inq, 0, 0);
}

void SetLeds( State )
unsigned State;
{
   /* Set the keyboard leds according to the locks in 'State' */
}
#endif
/*
 *      Busy wait for a keypress in kernel state for bootup/debug.
 */

int wait_for_keypress()
{
	return chq_getch(&ttys[0].inq, 0, 1);
}
