/*
For testing the console I use the following fragment of code, which
is in init/main.c just before fork()ing. If you want to try
it out, just insert it there.

Use:
   * Normal char key are copied to the cursor.
   * CTRL-X ends the loop and lets the init process to fork.
   * CTRL-Y deletes the current line
   * CTRL-I inserts a line at cursor
   * Normal vt52 escape sequences can be used, ie. pressing esc and then
     'H' moves the cursor to the cell 0,0. The arrow keys move the cursor,
     because vt52 arrows return the same sequence that is used to control
     the display too.
   * Do not test the 'identify' sequence ESC Z, unless you definitely
     want an infinite loop. Because almost all that is read from the kbd
     is echoed back, the responce string ESC Z is echoed too...
*/

{
int ch;
   while( ch = GetQueue() )
   {
      if( ch == -1 )
         continue;
      if( ch == 'X' - '@' )
         break;
      if( ch == 'Y' - '@' )
      {
         printk( "%cPd", 27 );
         continue;
      }
      if( ch == 'I' - '@' )
      {
         printk( "%cPf", 27 );
         continue;
      }
      printk( "%c", ch );
   }
}
