/*
 *	Tables from the Minix book, as thats all I have on XT keyboard controllers
 */

#include <linuxmt/types.h>
#include <arch/io.h>
#include <arch/keyboard.h>

static unsigned char xtkb_scan[]=
{
	0,033,'1','2','3','4','5','6',
	'7','8','9','0','-','=','\b','\t',
	'q','w','e','r','t','y','u','i',
	'o','p','[',']',015,0202,'a','s',
	'd','f','g','h','j','k','l',';',
	'\'',0140,0200,0134,'z','x','c','v',
	'b','n','m',',','.','/',0201,'*',
	0203,' ',0204,0241,0242,0243,0244,0245,
	0246,0247,0250,0251,0252,0205,0210,0267,
	0270,0271,0211,0264,0265,0266,0214,0261,
	0262,0263,'O',0177
};

static unsigned char xtkb_scan_shifted[]=
{
	0,033,'!','@','#','$','%','^',
	'&','*','(',')','_','+','\b','\t',
	'Q','W','E','R','T','Y','U','I',
	'O','P','{','}',015,0202,'A','S',
	'D','F','G','H','J','K','L',':',
	042,'~',0200,'|','Z','X','C','V',
	'B','N','M','<','>','?',0201,'*',
	0203,' ',0204,0221,0222,0223,0224,0225,
	0226,0227,0230,0231,0232,0204,0213,'7',
	'8','9',0211,'4','5','6',0214,'1',
	'2','3','0',0177
};

/*
 *	Keyboard state - the poor little keyboard controller hasnt
 *	got the brains to remember itself.
 */

static unsigned char shift_L=0,shift_R=0, control=0, alt=0, capslock=0, numlock=0;

/*
 *	XT style keyboard I/O is almost civilised compared
 *	with the monstrosity AT keyboards became.
 */
 
void keyboard_irq(irq,regs)
int irq;
struct pt_regs *regs;
{
	int code;
	int mode;
	int key;
	int make=1;
	
	extern int key_pressed;
	
	code=inb_p(KBD_IO);
	mode=inb_p(KBD_CTL);
	outb_p(mode,KBD_CTL);
	outb_p(mode, KBD_CTL);
	
	if(code&0x80)	/* Key release ? */
	{
		int k=code&~0x80;
		if(k!=29 && k !=42 && k != 54 && k != 56 & k != 69)
			return;	/* Boring */
		make=0;
	}

	/*
	 *	Pick the right keymap
	 */
	 
	if(shift_L||shift_R||capslock)
		key=xtkb_scan_shifted[code];
	else
		key=xtkb_scan[code];
	
	if(control & code < 14)
		key=xtkb_scan_shifted[code];
		
	if(code < 70 && numlock)
		key=xtkb_scan_shifted[code];
		
	/*
	 *	Apply special case rules
	 */
	 
	key&=0xFF;
	switch(key)
	{
		case 0200:
			shift_L=make;
			break;
		case 0201:
			shift_R=make;
			break;
		case 0202:
			control=make;
			break;
		case 0203:
			alt=make;
			break;
		case 0204:
			if(make)
				capslock=1-capslock;
			break;
		case 0205:
			if(make)
				numlock=1-numlock;
			break;
		default:
			/*
			 *	Apply special modifiers
			 */
			if(alt)
				key|=0x80;	/* META-.. */
			if(key==0)		/* non meta-@ is 64 */
				key='@';
			if(control)
				key&=0x1F;	/* CTRL-.. */
			if(!make)
				return;		/* Drop it */
			/*
			 *	Flag for init.
			 */	
			key_pressed=key;
			break;
	}
}

void xtk_init()
{
	printk("XT direct keyboard driver 0.02.\n");
}
