#include <linuxmt/types.h>
#include <linuxmt/config.h>
#include <linuxmt/sched.h>
#include <linuxmt/errno.h>


struct lp_info
{
	unsigned short io;
	char irq;
	char flags;
#define LPF_EXIST	1
};

static struct lp_info ports[3]=
{
	0x3BC,0,0,
	0x378,0,0,
	0x278,0,0
};


int lp_probe(lp)
struct lp_info *lp;
{
	int ct=0;
	outb(0,lp->io);
	while(ct++<50)	/* Slow slow slow .. udelay() in future */
		inb(0x80);
	if(inb(lp->io)==0)
	{
		lp->flags=LPF_EXIST;
		return 0;
	}
	return -1;
}
	
void lp_init()
{	
	struct lp_info *lp=&ports[0];
	int i;
	for(i=0;i<3;i++)
	{
		if(lp_probe(lp)==0)
		{
			printk("lp%d at 0x%x, using polling driver\n",
				i,lp->io);		
		}
		lp++;
	}
}
