/* mscdex.c */
/* Copyright (C) 1994 Yggdrasil Computing, Incorporated
   4880 Stevens Creek Blvd. Suite 205
   San Jose, CA 95129-1034
   USA
   Tel (408) 261-6630
   Fax (408) 261-6631

   This file is part of the Linux Kernel

   Linux is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   Linux is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with Linux; see the file COPYING.  If not, write to
   the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */
 

#include <linuxmt/kernel.h>
#include <linuxmt/sched.h>
/*#include <linuxmt/head.h>*/
#include <linuxmt/biosparm.h>
/*#include <linuxmt/page.h>*/
#include <linuxmt/major.h>
/*#include <linuxmt/mscdex.h>*/
/*#include <linuxmt/blk.h>*/
#include <linuxmt/fs.h>
/*#include <linux/signal.h>*/
#include <linux/cdrom.h>
#include <linux/string.h>
#include <asm/segment.h>

static int mscdex_ioctl ();
static int  mscdex_open ();
static void  mscdex_release ();

static struct file_operations mscdex_fops = {
	NULL,			/* lseek - default */
	block_read,		/* read - general block-dev read */
	block_write,		/* write - general block-dev write */
	NULL,			/* readdir - bad */
	NULL,			/* select */
	mscdex_ioctl,		/* ioctl */
	NULL,			/* mmap */
	mscdex_open,		/* open */
	mscdex_release,		/* release */
};

static int mscdex_initialized=0;
static unsigned char *msc_buff = NULL;
static unsigned long buff_sec = 0;
static unsigned long buff_len = 0;
static int buff_cd=-1;

static int no_cds=-1;
static int start_let=-1;
static struct {
  long sec_size;
  char letter;
} drive_info[26];

static unsigned short delay1=1;
static unsigned short delay2=50000;

static int
get_sec_size (int minor) {
  struct dos_ioctl *iptr;
  /* Get the actual sector size. */

  iptr=(void *)bios_buffer;
  iptr->len=33; /* offset of subcommand */
  iptr->subunit=0;
  iptr->command= DOS_IOCTLI; /* ioctl input */
  iptr->status = 0;
  iptr->res[0]=0;
  iptr->res[1]=0;
  iptr->descr=0;
  iptr->toff=OFFSET(&iptr->subcommand);
  iptr->tseg=SEGMENT(&iptr->subcommand);
  iptr->num=DIO_SEC_SIZE_LEN;
  iptr->sector=0;
  iptr->voloff=0;
  iptr->volseg=0;
  iptr->subcommand=DIO_SEC_SIZE;
  iptr->data.ret_long=0;
  
  cli();
  BD_AX=MSC_DEVREQ;
  BD_CX=drive_info[minor].letter;
  BD_BX=OFFSET(bios_buffer);
  BD_ES=SEGMENT(bios_buffer);
  BD_IRQ = MSCDEX_INT;
  call_bios();
  sti();
  if (CARRY_SET || iptr->status & 0x8000) {
    printk ("Unable to get Sector Size for drive %c (0x%X).\n",
	    drive_info[minor].letter+'A', iptr->status);
    drive_info[minor].sec_size = -1;
    return (-BD_AX&0xff);
  }
  drive_info[minor].sec_size = iptr->data.ret_long/256;
  return (0);
}


static void
mscdex_release (struct inode *inode, struct file *filp) {
  if (buff_cd == MINOR (inode->i_rdev)) 
    buff_cd = -1;
  return;
}

static int
mscdex_open (struct inode *inode, struct file *filp) {
  int minor;
  minor=MINOR(inode->i_rdev);
  if (mscdex_initialized == 0 || msc_buff == NULL) {
    return (-ENXIO);
  }
  if (minor>= no_cds) {
    return (-ENXIO);
  }

  return (0);
}
  


unsigned long
init_mscdex(unsigned long mem_start, unsigned long orig_lowmem) {

  int i;

  /* first we should check to see if dos is in place. */
  if (orig_lowmem == 4096) return (mem_start);

  if (no_bios) return (mem_start);

  /* now we need to check to see if the driver is in place and
     determine how many units we are dealing with. */
  cli();
  BD_IRQ = MSCDEX_INT;
  BD_AX = MSC_GETNUM;
  BD_BX = 0x00;

  call_bios();
  sti();

  /* see if we found anything */
  if (CARRY_SET || BD_BX == 0)
    return (mem_start);

  no_cds= BD_BX;
  start_let=BD_CX;

  printk("MSCDEX CD-Rom Driver Copyright (C) 1994 "
	 "Yggdrasil Computing, Inc.\n");
  if (no_cds == 1) {
    printk("MSCDEX CD-Rom Driver found 1 Drive\n");
  } else {
    printk("MSCDEX CD-Rom Driver found %d Drives\n", no_cds);
  }

  cli();
  BD_AX = MSC_GETLETS;
  BD_BX = OFFSET(bios_buffer);
  BD_ES = SEGMENT(bios_buffer);

  call_bios();
  sti();

  if (no_cds == 1) {
    printk ("drive letter found: ");
  } else {
    printk ("drive letters found: ");
  }
  for (i = 0; i < no_cds; i++) {
    drive_info[i].letter=bios_buffer[i];
    /* it appears linux wants 512 byte blocks */
    mscdex_blocksizes[i]=1024;
    drive_info[i].sec_size = -1;

    printk ("%c ",drive_info[i].letter+'A');
  }
  printk ("\n");

  i=register_blkdev(MAJOR_NR, DEVICE_NAME, &mscdex_fops);

  if (i==0) {
    blk_dev[MAJOR_NR].request_fn = DEVICE_REQUEST;
    blksize_size[MAJOR_NR]=mscdex_blocksizes;
    /* read_ahead[MAJOR_NR]=8; */
    mscdex_initialized=1;
    msc_buff = (unsigned char *)mem_start;
    return (mem_start + BIOS_BUFF);
  }

  if (i==-EBUSY) {
    printk ("MSCDEX: Major Number already in use, driver not installed\n");
    return (mem_start);
  }
  printk ("MSCDEX: Major Number to Great??? (%d) driver not installed\n", i);
  return (mem_start);
}

static int
mscdex_ioctl (struct inode *inode,
	      struct file *file,
	      unsigned int op,
	      unsigned long arg)
{
  struct dos_ioctl *iptr;
  int minor;
  struct cdrom_msf msf; 
 
  minor=MINOR(inode->i_rdev);
  if (minor >= no_cds) {
    return (-ENXIO);
  }
  
  switch (op) {

  case CDROMPAUSE:
    iptr=(void *)bios_buffer;
    iptr->len=13; /* offset of descr */
    iptr->subunit=0;
    iptr->command=DOS_STOP_AUDIO;
    iptr->status = 0;
    iptr->res[0]=0;
    iptr->res[1]=0;

    cli();
    BD_AX=MSC_DEVREQ;
    BD_CX=drive_info[MINOR(inode->i_rdev)].letter;
    BD_BX=OFFSET(bios_buffer);
    BD_ES=SEGMENT(bios_buffer);
    BD_IRQ = MSCDEX_INT;
    call_bios();
    sti();
    if (CARRY_SET || iptr->status&0x8000) {
      return (-EIO);
    }
    return (0);

  case CDROMRESUME:
    iptr=(void *)bios_buffer;
    iptr->len=13; /* offset of descr */
    iptr->subunit=0;
    iptr->command=DOS_RES_AUDIO;
    iptr->status = 0;
    iptr->res[0]=0;
    iptr->res[1]=0;

    cli();
    BD_AX=MSC_DEVREQ;
    BD_CX=drive_info[MINOR(inode->i_rdev)].letter;
    BD_BX=OFFSET(bios_buffer);
    BD_ES=SEGMENT(bios_buffer);
    BD_IRQ = MSCDEX_INT;
    call_bios();
    sti();
    if (CARRY_SET || iptr->status & 0x8000) {
      return (-EIO);
    }
    return (0);
    
    iptr=(void *)bios_buffer;
    iptr->len=13; /* offset of descr */
    iptr->subunit=0;
    iptr->command=DOS_STOP_AUDIO;
    iptr->status = 0;
    iptr->res[0]=0;
    iptr->res[1]=0;

    cli();
    BD_AX=MSC_DEVREQ;
    BD_CX=drive_info[MINOR(inode->i_rdev)].letter;
    BD_BX=OFFSET(bios_buffer);
    BD_ES=SEGMENT(bios_buffer);
    BD_IRQ = MSCDEX_INT;
    call_bios();
    sti();
    if (CARRY_SET || iptr->status & 0x8000) {
      return (-EIO);
    }
    return (0);

  case CDROMPLAYMSF:
    memcpy_fromfs (&msf, (void *)arg, sizeof (msf));
    iptr=(void *)bios_buffer;
    iptr->len=22; /* offset of sector */
    iptr->subunit=0;
    iptr->command=DOS_PLAY_AUDIO;
    iptr->status = 0;
    iptr->res[0]=0;
    iptr->res[1]=0;
    iptr->descr = 1; /* Red Book Addressing Mode */
    iptr->toff = msf.cdmsf_frame0 | (msf.cdmsf_sec0 << 8);
    iptr->tseg = msf.cdmsf_min0;
    iptr->tlen = msf.cdmsf_frame1 | (msf.cdmsf_sec1 << 8);
    iptr->num = msf.cdmsf_min1;

    cli();
    BD_AX=MSC_DEVREQ;
    BD_CX=drive_info[MINOR(inode->i_rdev)].letter;
    BD_BX=OFFSET(bios_buffer);
    BD_ES=SEGMENT(bios_buffer);
    BD_IRQ = MSCDEX_INT;
    call_bios();
    sti();
    if (CARRY_SET || iptr->status &0x8000) {
      return (-EIO);
    }
    return (0);
  }
  return -EINVAL;
}


/* As far as I can tell this doesn't actually
   work, but we might as well try it. */
static void
reset_mscdex(int minor) {
  int odelay1;
  int odelay2;
  struct dos_ioctl *iptr;

  schedule();  /* waste some time. */

  cli();
  odelay1=BD_DELAY1;
  odelay2=BD_DELAY2;
  BD_DELAY1=delay1;
  BD_DELAY2=delay2;
  sti();
  

  iptr=(void *)bios_buffer;
  iptr->len=33; /* offset of subcommand */
  iptr->subunit=0;
  iptr->command= DOS_IOCTLI; /* ioctl input */
  iptr->status = 0;
  iptr->res[0]=0;
  iptr->res[1]=0;
  iptr->descr=0;
  iptr->toff=OFFSET(&iptr->subcommand);
  iptr->tseg=SEGMENT(&iptr->subcommand);
  iptr->num=DIO_DEV_STATUS_LEN;
  iptr->sector=0;
  iptr->voloff=0;
  iptr->volseg=0;
  iptr->subcommand=DIO_DEV_STATUS;
  iptr->data.ret_long=0;
  printk ("MSCDEX: Checking drive %c\n", drive_info[minor].letter+'A');

  cli();
  BD_AX=MSC_DEVREQ;
  BD_CX=drive_info[minor].letter;
  BD_BX=OFFSET(bios_buffer);
  BD_ES=SEGMENT(bios_buffer);
  BD_IRQ = MSCDEX_INT;
  call_bios();
  sti();
  if (CARRY_SET) {
    printk ("Error Checking Status: AX=0x%04X\n", BD_AX);
  }
  printk ("MSCDEX Drive Status: 0x%08lX ", iptr->data.ret_long);
  printk ("return status: 0x%04X ",iptr->status);
  printk ("\n");
  
  schedule();  /* waste some time. */

  iptr=(void *)bios_buffer;
  iptr->len=33; /* offset of subcommand */
  iptr->subunit=0;
  iptr->command=DOS_IOCTLI;
  iptr->status = 0;
  iptr->res[0]=0;
  iptr->res[1]=0;
  iptr->descr=0;
  iptr->toff=OFFSET(&iptr->subcommand);
  iptr->tseg=SEGMENT(&iptr->subcommand);
  iptr->num=DIO_MED_CHANGE_LEN;
  iptr->sector=0;
  iptr->voloff=0;
  iptr->volseg=0;
  iptr->subcommand=DIO_MED_CHANGE; /* Media Change status */
  iptr->data.ret_long=0;

  cli();
  BD_AX=MSC_DEVREQ;
  BD_CX=drive_info[minor].letter;
  BD_BX=OFFSET(bios_buffer);
  BD_ES=SEGMENT(bios_buffer);
  BD_IRQ = MSCDEX_INT;
  call_bios();
  sti();

  schedule();  /* waste some time. */
  iptr=(void *)bios_buffer;
  iptr->len=33; /* offset of subcommand */
  iptr->subunit=0;
  iptr->command=DOS_IOCTLO;
  iptr->status = 0;
  iptr->res[0]=0;
  iptr->res[1]=0;
  iptr->descr=0;
  iptr->toff=OFFSET(&iptr->subcommand);
  iptr->tseg=SEGMENT(&iptr->subcommand);
  iptr->num=DIO_RESET_LEN;
  iptr->sector=0;
  iptr->voloff=0;
  iptr->volseg=0;
  iptr->subcommand=DIO_RESET;

  cli();
  BD_AX=MSC_DEVREQ;
  BD_CX=drive_info[minor].letter;
  BD_BX=OFFSET(bios_buffer);
  BD_ES=SEGMENT(bios_buffer);
  BD_IRQ = MSCDEX_INT;
  call_bios();
  sti();
  printk ("MSCDEX Reset: ");
  if (CARRY_SET) {
    printk ("Error: AX=0x%04X ", BD_AX);
  }
  printk ("status: 0x%04X ",iptr->status);
  printk ("\n");
}

static void
do_mscdex_request(void) {
  unsigned long start;
  unsigned long count;
  unsigned long this_pass;
  unsigned long offset;
  unsigned long len;
  unsigned short odelay1;
  unsigned short odelay2;
  char *buff;
  int minor;
  int sec_size;
  int sec_fact;

  extern unsigned long loops_per_sec;

  while (1) {
  next_block:

    /* make sure we have a valid request */
    if (!CURRENT || CURRENT->dev < 0) return;

    /* now initialize it */
    INIT_REQUEST;

    /* make sure it's still valid */
    if (CURRENT == NULL || CURRENT->sector == -1) return;

  
    /* we don't do writes yet. */
    if (CURRENT->cmd == WRITE) {
      end_request(0);
      continue;
    }

    if (!mscdex_initialized) {
      end_request(0);
      continue;
    }

    minor=MINOR(CURRENT->dev);

    /* make sure it's a cd we are dealing with. */
    if (minor>=no_cds) {
      end_request(0);
      continue;
    }

    sec_size=drive_info[minor].sec_size;
    if (sec_size == -1) {
      if (get_sec_size(minor) != 0) {
	sec_size=2048; /* guess */
      } else {
	sec_size = drive_info[minor].sec_size;
      }
    }

    sec_fact = sec_size/512;
  
    buff = CURRENT->buffer;
    count = CURRENT->nr_sectors;
    start = CURRENT->sector;

    /* try to satisfy the request from the extra cache */
    
    if (minor == buff_cd &&
	start >= buff_sec*sec_fact &&
	start < (buff_sec + buff_len)*sec_fact) {
      /* we can get some of this from the cache, maybe all of it. */
      offset = (start - buff_sec*sec_fact);
      len = buff_len*sec_fact-offset;
      if (count < len) len = count;
      memcpy (buff, msc_buff+offset*512, len*512);
      count -= len;
      start -= len;
      buff += len*512;
    }
	
    while (count > 0) {


      /* Always read in as much as possible. */
      this_pass = BIOS_BUFF/sec_size;

      cli();
      BD_IRQ=MSCDEX_INT;
      BD_AX=MSC_READ;
      BD_BX=OFFSET(bios_buffer);
      BD_ES=SEGMENT(bios_buffer);
      BD_CX=drive_info[minor].letter;
      BD_DX=this_pass;
      BD_SI=(start/sec_fact)>>16;
      BD_DI=(start/sec_fact)&0xffff;
      BD_FL=0;
      odelay1=BD_DELAY1;
      odelay2=BD_DELAY2;
      BD_DELAY1=delay1*((loops_per_sec+499999)/500000);
      BD_DELAY2=delay2;

      call_bios();

      BD_DELAY1=odelay1;
      BD_DELAY2=odelay2;

      sti();
      if (CARRY_SET) {
	printk ("MSCDEX error: AX=0x%X \n", BD_AX);
	if (BD_AX&0xff==21) {
	  printk ("MSCDEX: cdrom not ready\n");
	  CURRENT->errors++;
	  if (CURRENT->errors> 5) {
	    end_request(0);
	    goto next_block;
	  }
	} else {
	  printk ("MSCDEX: Invalid Drive or other error\n");
	  CURRENT->errors++;
	  if (CURRENT->errors > 5) {
	    end_request(0);
	    goto next_block;
	  }
	}
	reset_mscdex(MINOR(CURRENT->dev));
	continue; /* try again */
      }

      /* copy everything into the extra buffer. */
      memcpy (msc_buff, bios_buffer, BIOS_BUFF);
      buff_cd = minor;
      buff_len = this_pass;
      buff_sec=start/sec_fact;

      /* copy the request from the cd rom cache */
      offset = (CURRENT->sector - buff_sec*sec_fact);
      len = buff_len*sec_fact-offset;
      if (count < len) len = count;

      memcpy (buff, msc_buff+offset*512, len*512);
      count -= len;
      start -= len;
      buff += len*512;
    }
    /* satisfied that request */
    end_request(1);
  }
}

void mscdex_setup (char *str, int *ints) {
  
  if (ints[0]>=1)
    delay1=ints[1];
  if (ints[0]==2)
    delay2=ints[2];
}
