#include "ssh.h"

struct ssh_kex ssh_diffiehellman = {
    "diffie-hellman-group1-sha1"
};

/*
 * The prime p used in the key exchange. 
 */
static unsigned short P[] = {
    64,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x5381, 0xECE6, 0x6651, 0x4928,
    0x1FE6, 0x7C4B, 0x2411, 0xAE9F, 0x9FA5, 0x5A89, 0x6BFB, 0xEE38,
    0xB7ED, 0xF406, 0x5CB6, 0x0BFF, 0xED6B, 0xA637, 0x42E9, 0xF44C,
    0x7EC6, 0x625E, 0xB576, 0xE485, 0xC245, 0x6D51, 0x356D, 0x4FE1,
    0x1437, 0xF25F, 0x0A6D, 0x302B, 0x431B, 0xCD3A, 0x19B3, 0xEF95,
    0x04DD, 0x8E34, 0x0879, 0x514A, 0x9B22, 0x3B13, 0xBEA6, 0x020B,
    0xCC74, 0x8A67, 0x4E08, 0x2902, 0x1CD1, 0x80DC, 0x628B, 0xC4C6,
    0xC234, 0x2168, 0xDAA2, 0xC90F, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
};

/*
 * The order q of the group: (p-1)/2.
 */
static unsigned short Q[] = {
    64,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x29C0, 0xF673, 0x3328, 0x2494,
    0x8FF3, 0xBE25, 0x9208, 0xD74F, 0xCFD2, 0xAD44, 0x35FD, 0xF71C,
    0x5BF6, 0x7A03, 0xAE5B, 0x85FF, 0xF6B5, 0xD31B, 0x2174, 0x7A26,
    0x3F63, 0x312F, 0xDABB, 0xF242, 0xE122, 0xB6A8, 0x9AB6, 0xA7F0,
    0x8A1B, 0xF92F, 0x8536, 0x9815, 0x218D, 0xE69D, 0x8CD9, 0xF7CA,
    0x026E, 0xC71A, 0x043C, 0x28A5, 0xCD91, 0x1D89, 0xDF53, 0x0105,
    0xE63A, 0x4533, 0x2704, 0x9481, 0x0E68, 0xC06E, 0x3145, 0x6263,
    0x611A, 0x10B4, 0xED51, 0xE487, 0xFFFF, 0xFFFF, 0xFFFF, 0x7FFF,
};

/*
 * The bitmask covering q (for ease of generation of x).
 */
static unsigned short Qmask[] = {
    64,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF,
    0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x7FFF,
};

/*
 * The generator g = 2.
 */
static unsigned short G[] = { 1, 2 };

/*
 * Variables.
 */
static Bignum x, e;

/*
 * DH stage 1: invent a number x between 1 and q, and compute e =
 * g^x mod p. Return e.
 */
Bignum dh_create_e(void) {
    int i;

    x = newbn(Q[0]);

    do {
	/*
	 * Create a potential x, by ANDing a string of random bytes
	 * with Qmask.
	 */
	for (i = 1; i <= x[0]; i++)
	    x[i] = ((random_byte() << 8) + random_byte()) & Qmask[i];
    } while (bignum_cmp(x, One) <= 0 || bignum_cmp(x, Q) >= 0);

    /*
     * Done. Now compute e = g^x mod p.
     */
    e = modpow(G, x, P);

    return e;
}

/*
 * DH stage 2: given a number f, compute K = f^x mod p.
 */
Bignum dh_find_K(Bignum f) {
    return modpow(f, x, P);
}
