/* 
  What does this program do?
  
  this program takes each path in the directory file
  and parse the path into two part
  <directory name>  <full path>
  the output are redirect to dirdata.jmp  
  
  I welcome your comments, ideas and effort to improved this utility.
  Areas that need improvement:
  1) need a more sophisticated data structure to store directory 
  information.
  2) need seperate directory information for root user, different group 
  users and additional one for each user to reduce disk storage for
  directory information. Now, JUMP maintains a dirdata.jmp for each
  user who uses JUMP.  
  
  JUMP is a freeware which adheres to the principle that sharing software with 
  all who would do the same. Modification to source codes are hereby granted 
  provided your modified version must release with source codes.  I would
  appreciate if you can email a copy of your improved version JUMP.
  
  (C) Weijin Mai   Jan.11.1993
  email addresses:
  internet: cl820@cleveland.freenet.edu (perminent email address)
  wjmcc@cunyvm.cuny.edu         
  bitnet  : c4m84567@cunyvme.bitnet@cunyvm.cuny.edu (frequent broken mail)
  
  */

#include <stdio.h>
#include <errno.h>
#include <string.h>

#define MAX_PATH_LEN  1000
#define MAX_DIR_LEN  100

int IparsePath(char *);

int main(int argc , char* argv[])
{
  /* argv[1] is the filename which stores the full path to be parsed */
  if( argc == 2 )
    {
      return IparsePath( argv[1] );
      return 0;
    }
  else
    {
      fprintf(stderr , " this utility is invoked from j. please run : . j dir_name \n"); 
      return 1;
    }
}

int IparsePath(char* cpFile_read )
{
  FILE* pfile_read = NULL;
  char Apath_in_file[MAX_PATH_LEN];
  char Adir[MAX_DIR_LEN];
  char Apath[MAX_PATH_LEN];
  char* cpdir = NULL;
  
  pfile_read = fopen( cpFile_read, "r" );
  
  if( pfile_read == NULL ) 
    {
      fprintf(stderr,"\nopen %s for input failed : %s", cpFile_read, strerror(errno));    
      return 1;
    }
  
  while( fscanf( pfile_read, "%s", Apath_in_file) != EOF )
    {
      cpdir = strrchr( Apath_in_file, '/' );
      if( cpdir != NULL )
	{
	  strcpy( Adir, cpdir+1 );
	  printf("\n%s %s", Adir, Apath_in_file );
        }  
    }
  
  return 0;
}









