/* 
What does file do ? 
   1) match user specified directory with entries in dirdata.jmp
   2) and ask user to pick an appropiate directory,
   3) then write the full path of that directory to a temp file which 
      to be read from the JUMP script.

I welcome your comments, ideas and effort to improved this utility.
Areas that need improvements :
      1) need a more sophisticated data structure to store directory 
         information.
      2) need seperate directory information for root user, different group 
         users and additional one for each user to reduce disk storage for
         directory information. Now, JUMP maintains a dirdata.jmp for each
         user who uses JUMP. 
   
JUMP is a freeware which adheres to the principle that sharing software with 
all who would do the same. Modification to source codes are hereby granted 
provided your modified version must release with source codes.  I would
appreciate if you can email a copy of your improved version JUMP.

(C) Weijin Mai   Jan.11.1993
email addresses:
     internet: cl820@cleveland.freenet.edu (preferred email address)
               wjmcc@cunyvm.cuny.edu         
     bitnet  : c4m84567@cunyvme.bitnet@cunyvm.cuny.edu (frequent broken mail)
   */
 
#include <stdio.h>
#include <errno.h>
#include <stdlib.h>
#include <ctype.h>
#include "dirl.h"

#ifndef MAX_PATH_LEN
#define MAX_PATH_LEN  1000
#endif
#ifndef MAX_DIR_LEN
#define MAX_DIR_LEN  100
#endif

#ifndef WILDCARD
#define WILDCARD ']'
#endif

int MatchDir(char*);

int main(int argc, char* argv[])
{
  
  char cpArgv1[MAX_DIR_LEN];
  
  if (argc == 2) {
    strcpy( cpArgv1, argv[1] );       
    return MatchDir( cpArgv1 );  
  }
  else
    {
     fprintf(stderr , " this utility is invoked from j. please run : . j dir_name \n"); 
     return 0; 
    }  
}

int MatchDir( char* Adirectory )
{
   
  char ApathInFile[MAX_PATH_LEN];
  char AdirInFile[MAX_DIR_LEN];  
  char MatchDir[50][MAX_PATH_LEN];          /* pathes that match Adirectory */
  char AChPath[MAX_PATH_LEN];                /* full path for Adirectory */
  char input[3];
  char AHomeDir[MAX_PATH_LEN];
  
  DirLink dirl;
  string* pS = NULL;

  int i = 0;
  int j = 0;
  int count = 0;
  int choice  = 0;
  int iNumCompChar = 0;        /* # of character to be compared */
  int iNumLine = 20;

  FILE* pfile_read;
  FILE* pfile_write;
  
  char Afile_read[200];
  char Afile_write[200];
  
  strcpy( AHomeDir, getenv("HOME"));
  strcpy( Afile_read, AHomeDir );
  strcat( Afile_read, "/.dirdata.jmp");
  strcpy( Afile_write, AHomeDir );
  strcat( Afile_write, "/.jumppath.tmp");
  
  pfile_read = fopen(Afile_read, "r");
  pfile_write = fopen(Afile_write, "w");
  if( (pfile_read == NULL) || (pfile_write == NULL) )
    {
      fprintf(stderr,"\nopen %s for input failed : %s", Afile_read, strerror(errno));
      return 1;
    }
  
  /* scan dirdata.jmp for all directory that match to Adirectory  */
  
  if ( strrchr( Adirectory, WILDCARD ) )
    {
      iNumCompChar = strlen( Adirectory ) - 1;    
    }
  else
    { 
      iNumCompChar = MAX_DIR_LEN ;
    }
  
  
  while( fscanf( pfile_read, "%s %s", AdirInFile, ApathInFile) != EOF )
    {
      if( strncmp( Adirectory, AdirInFile, iNumCompChar ) == 0 ) 
	{
          pS = new string( AdirInFile, ApathInFile );
          dirl.addDir( pS ); 
	}
    } 
  
  
  fclose (pfile_read );
  
  dirl.resetCurrent2Head();
  count = dirl.get_count();
 

  /* if there is more than one match, pop user for selection
     if there is no match, return 1.
     if there is exactly one match, write full path to jumppath.tmp
     */
  
  if( count == 0 )
    {
      printf("\n! No match path for directory %s !\n", Adirectory );
      return 1;
    }
  
  if (count > 1 ) { 
    for(i=0, j=0; i < count; i++) {
      pS = (string*) dirl.getNextItem();
      strcpy( MatchDir[j], pS->get_path() );
      printf("\n <%d> %s",j+1, pS->get_path() );
      j++;
      if( ( j == iNumLine ) || ( i == count -1 ) ) 
         {
         if( i == count -1 )
            printf("\n <0> exit ");
         else
            printf("\n <0> for next page , more ...");
         do {
           printf("\n pattern : %s" , Adirectory );
           printf("\nPick one : ");
           scanf("%2s",input);
           if( *input > '9' || *input < '0'  ) 
              {
              Adirectory[ strlen( Adirectory )-1 ] = *input;
              strcat( Adirectory , "]" );
              dirl.shrinkDirList( Adirectory ); 
              dirl.resetCurrent2Head();  
              count = dirl.get_count();
              i = -1;
              j = 0;
              }
           else
              choice = atoi( input );
          
           fflush(stdin);
           } while ((choice < 0) || (j < choice));
         j = 0;
         }
     
     if( choice != 0 || count == 1 ) break;
     } 
  }
  if( count == 1 )
    {
    pS = (string*) dirl.getNextItem();
    strcpy(MatchDir[0], pS->get_path());
    choice = 1; 
    }

  if( choice != 0 ) {
    strcpy(AChPath,MatchDir[choice-1]);
    if( fprintf( pfile_write, "%s", AChPath ) == EOF )
      {
	return 1;
      }         
  }
  else 
    return 0;   
  
  fclose(pfile_write);        
  return 0;
}














