/* 
Class relationship:
  ITEM--->NUMBERS(STRING)--->LINKLIST--->DIRLIST
                                         |
                                         V
                                     jumpdir.cc
 
I welcome your comments, ideas and effort to improved this utility.
Areas that need improvements:
      1) need a more sophisticated data structure to store directory 
         information.
      2) need seperate directory information for root user, different group 
         users and additional one for each user to reduce disk storage for
         directory information. Now, JUMP maintains a dirdata.jmp for each
         user who uses JUMP.    
JUMP is a freeware which adheres to the principle that share software with 
all who would do the same. Modification to source codes are hereby granted 
provided your modified version must release with source codes.  I would
appreciate if you can email me a copy of your improved version JUMP.

(C) Weijin Mai   Jan.11.1993
email addresses:
     internet: cl820@cleveland.freenet.edu (preferred email address)
               wjmcc@cunyvm.cuny.edu         
     bitnet  : c4m84567@cunyvme.bitnet@cunyvm.cuny.edu (frequent broken mail)
   */

// ITEM is a generic data type for link list
// all derived classes of this base class can
// be worked in a link list

#define ITEM
#include <iostream.h>

class Item {
public:
    Item *next;                          // public pointer to the next item.
					 // could be made private and delcear
					 // link list as a friend of Item.
					 // but since Item is already a data
					 // member(relative) of link list, a friend is
					 // not as close as a relative :).
    Item() { next = NULL; };             // NULL next!

    void virtual display_item() = 0;     // has no real function except provide
					 // a standard interface for his child or grand
					 // child to follow
    void virtual get_item() = 0;         // ditto
};


//---------------------------------------------------------------
// define string class 

#define NUMBERS
#include <string.h>

#ifndef ITEM
#include "item.cc"
#endif

#ifndef MAX_DIR_LEN
#define MAX_DIR_LEN 100
#define MAX_PATH_LEN 1000
#endif

// a string class derived from base class Item
class string : public Item{
public:
    char  dir[ MAX_DIR_LEN ];
    char  path[ MAX_PATH_LEN ];
public:

    string( char *pDir, char* pPath ) : Item()  { strcpy( dir, pDir); strcpy( path, pPath); }
    string()      : Item() { get_item() ;   }
    void virtual display_item() { cout << dir <<"="<<path<<" "; }
    void virtual get_item() { cout << "enter a string: "; cin >> dir; }
    char* get_dir() { return dir; }
    char* get_path() { return path; }
};


//---------------------------------------------------------------

// LINKLIST is a single link list
// this link list exploits the property of common base class ITEM
// since class INTEGER and class FLOAT are derived from class ITEM, the two classes
// are able to fit in the same link list

#define LINKLIST

#ifndef NUMBERS
#include "string.cc"
#endif


class LinkList {
  Item *list;
public:
  LinkList() { list = NULL; };
  ~LinkList(){};

  int append( Item* );                            //add new item to the tail
  int add( Item* );                               //add new item to the head of the list
  int remove( Item* );                            //remove item from anywhere in the link list
  void display(void);
  int is_empty(void) { return( list == NULL ? 1 : 0 ); };
  char* get_string_dir( string* i )  { return i->get_dir(); };
  Item* get_head(void) { return list; };
};

//--------------------------------------------------------------------
/* this class provides functions to manipulate a link list of directories 
   using in both UNIX/MSDOS versions of JUMP
*/   

#ifndef LINKLIST
#include "linklist.h"
#endif

#ifndef WILDCARD
#define WILDCARD ']'
#endif

class DirLink : public LinkList {
   Item *head;
   Item *current;
   int  count;
public:
   DirLink();
   ~DirLink() {}; 
  
   int addDir( Item* );             // add an item to linklist
   int shrinkDirList( char * );      // narrow linklist to entries match argu
   Item* getNextItem(void);
   void resetCurrent2Head() { current = head ; };
   void updateHead(void) { head = LinkList::get_head() ; }; 
   void display(void);
   int get_count(void) { return count; };   
};

