 

#include "dirl.h"

int LinkList::add( Item* i )
{
  Item* first_item;

  if( list == NULL )
     list = i;
  else {
     first_item = list;
     list = i;
     list->next = first_item;
     }

  return 0;
}

int LinkList::append(Item* i)
{
   Item *current;

   if( list == NULL )
      list = i;
   else {               // go to the end of the link list
      current = list;
      while( current->next != NULL ) {
	 current = current->next;
	 }               // at the end of the link list
      current->next = i; // add the new item to the end of the link list
      }
  return 0;

};

int LinkList::remove(Item* i)
{
   Item *current;
   Item *previous;

   if( list == NULL )                //list is empty, do nothing
	 return 1;

   if( i == list )                  //delete head of the list
      {
      list = list->next;
      delete i;
      return 0;
      }

   current = list;
   while( current != i )            //move to the right position in the link list
      {
      previous = current;
      current = current->next;
      }

   previous->next = current->next;  //establish new link
   delete i;                        //delete item

   return 0;
};

void LinkList::display(void)
{
   Item *current;

   if( list != NULL )                    // print out item value in a walkthrugh of the link list
      {
      current = list;
      while( current != NULL)
	 {
	 current->display_item();
	 current = current->next;
	 }
      }
   else
       cout<<" link list is empty ";

};



//--------------------------------------------------------------------
/* this class provides functions to manipulate a link list of directories 
   using in JUMP for msdos/unix.   
*/   



DirLink::DirLink() : LinkList()
{
  head = NULL;
  current = NULL;
  count = 0;
};

Item* DirLink::getNextItem(void)
{
   Item* tmp = NULL;

   tmp = current;
   current = current->next;
 
   return tmp;
};

int DirLink::addDir( Item* i ) 
{
   if( head == NULL )
      {
      head = i;
      current = head;
      }
   LinkList::append( i );
 
   count++;
  
   return 0;
};

int DirLink::shrinkDirList( char* cpCompStr)
{
  int iNumCompChar = 0;
  char* cpItemStr = NULL;
  Item* tmp = NULL;
  
  
  if (strrchr( cpCompStr, WILDCARD ))
    {
    iNumCompChar = strlen( cpCompStr) - 1;
    }
  else
    iNumCompChar = MAX_DIR_LEN ; 
  
  resetCurrent2Head();
   
  while( current )
    {
  
    tmp = current->next;
    cpItemStr = get_string_dir( (string*) current );
    if( strncmp( cpCompStr, cpItemStr, iNumCompChar ) != 0 )    
          {          
          //cout << "\n delete " << cpItemStr;
          LinkList::remove( current );
          count--;
          } 
    current = tmp;
    }  
  
  
  
  //head = LinkList::get_head();    //head might be removed form the dirlist
                                    //call linklist for the new head! 
  updateHead();
  resetCurrent2Head();
   
  return 0;
};
   


void DirLink::display(void)
{  
   cout<<"DirLink --> ";
   LinkList::display();
   cout<<" <-- \n";
};













