#include <stdio.h>
#include <unistd.h>
#include <termios.h>
#include <fcntl.h>
#include <signal.h>

unsigned char buf[2];
struct termios tiopar[1], tiosave[1];

void cleanup()
{
	tcsetattr(0, TCSAFLUSH, tiosave);
}

void sighandler() {
	cleanup();
	exit(1);
}

void init()
{
	struct sigaction sa;
	unsigned long s;

	fcntl(0, F_SETFL, O_NONBLOCK);
	tcgetattr(0, tiopar);
	memcpy(tiosave, tiopar, sizeof(struct termios));
	tiopar->c_lflag &= ~ICANON;
	tiopar->c_lflag &= ~ECHO;
	tcsetattr(0, TCSAFLUSH, tiopar);

	for(s=1; s!=32; s++) {
		sa.sa_handler=sighandler;
		sa.sa_flags=SA_RESTART;
		sigaction(s, &sa, NULL);
	}
}

int main()
{
	init();

	while(!(read(0, buf, 1)>0))
		usleep(125000);
	printf("%c\n", buf[0]);

	cleanup();

	return(0);
}

