#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "config.h"

extern char *basename __P((__const char *__name));

int main(int argc, char *argv[])
{

  FILE *f=stdin;
  unsigned int count=0x00;
  int l, cnt=0x10;
  unsigned char sum[0x10], buf[0x10], chars[0xff];

  argv[0]=basename(argv[0]);
  if (argc!=1)
  {
    if (argc==2)
    {
      if (!memcmp(argv[1], "-", 1))
      {
        if (!strcmp(argv[1], "--help"))
        {
          printf("\n  %s rev.1.4 by Andreas H. Mueller\n", argv[0]);
          printf("  (cameron@RadioFlora.apc.de) in 1998.\n");
	  printf("  Configured on "C_HOST" ("C_CC"),\n  "C_TIME" by "C_USER".\n");
          printf("  This program is distributed under the terms of the GNU public license.\n\n");
          printf("  Usage : %s <FILE> | <--help>\n\n", argv[0]);
          printf("   %s is a utility that i've written in frustration about\n", argv[0]);
          printf("  the output-format of the normal 'hexdump' - utility.\n");
          printf("  It is inspired by the memory-dump functions of the 'good old'\n");
          printf("  proggies called monitors like on the Commodore 64 or Amiga.\n");
          printf("   FILE is the name of the file you want to dump including the\n");
          printf("  path to it, if needed. If not specified, %s uses STDIN as\n  input.\n", argv[0]);
          printf("\n   %s returns the following error-codes:\n", argv[0]);
          printf("\n  1 : Help called\n");
          printf("  2 : Unknown option.\n");
          printf("  3 : Too much parameters\n");
          printf("  4 : Error while opening FILE.\n\n");
          return 1;
        }
        else
        {
          if (!strcmp(argv[1], "-RN"))
          {
            printf("  The original name of this tool is cdump, the revision is 1.4.\n");
            return 0xff;
          }
          else
          {
            fprintf(stderr, "%s: Error: Unknown option.\n", argv[0]);
            fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
            return 2;
          }
        }
      }
    }
    else
    {
      fprintf(stderr, "%s: Error: Too much parameters.\n", argv[0]);
      fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
      return 3;
    }
  }
  if(argc==1) {
    f=stdin;
  }
  else {
    if (!(f=(fopen(argv[1], "r")))) {
      fprintf(stderr, "%s: Error while opening %s.\n", argv[0], argv[1]);
      return 4;
    }
  }
  for(l=0; l!=0xff; l++)
    chars[l]='.';
  for(l=0x20; l!=0x7e; l++)
    chars[l]=l;
  while(cnt==0x10) {
    cnt=fread(buf, 1, 0x10, f);
    for(l=0; l!=0x10; l++)
      sum[l]=chars[buf[l]];
    if(cnt==0x10)
      printf("%8.8x:"
	     "%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x"
	     "%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x%3.2x"
             " %16.16s\n",
	     count,
	     buf[0], buf[1], buf[2], buf[3], buf[4], buf[5], buf[6], buf[7],
	     buf[8], buf[9], buf[10], buf[11], buf[12], buf[13], buf[14], buf[15],
	     sum);
    else
      if(cnt!=0) {
	printf("%8.8x:", count);
	for(l=0; l!=cnt; l++)
	  printf("%3.2x", buf[l]);
	for(; l!=0x10; l++) {
	  printf("   ");
	  sum[l]=' ';
        }
        printf(" %16.16s\n", sum);
      }
    count+=0x10;
  }   
  fclose(f);
  return 0;
}

