#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include "config.h"

extern char *basename __P((__const char *__name));

char compinfo[]=C_HOST;
char comptime[]=C_TIME;
char compuser[]=C_USER;

int main(int argc, char *argv[])
{

  FILE *f=stdin;
  unsigned int count=0x00;
  int l, c=0x00;
  char sum[0x10];

  argv[0]=basename(argv[0]);
  if (argc!=1)
  {
    if (argc==2)
    {
      if (!memcmp(argv[1], "-", 1))
      {
        if (!strcmp(argv[1], "--help"))
        {
          printf("\n  %s rev.1.3 by Andreas H. Mueller\n", argv[0]);
          printf("  (cameron@rupert.stochastik.rwth-aachen.de) in 1997.\n");
	  printf("  Configured on %s,\n  %s by %s.\n", compinfo, comptime, compuser);
          printf("  This program is distributed under the terms of the GNU public license.\n\n");
          printf("  Usage : %s <FILE> | <--help>\n\n", argv[0]);
          printf("   %s is a utility that i've written in frustration about\n", argv[0]);
          printf("  the output-format of the normal 'hexdump' - utility.\n");
          printf("  It is inspired by the memory-dump functions of the 'good old'\n");
          printf("  proggies called monitors like on the Commodore 64 or Amiga.\n");
          printf("   FILE is the name of the file you want to dump including the\n");
          printf("  path to it, if needed. If not specified, %s uses STDIN as\n  input.\n", argv[0]);
          printf("\n   %s returns the following error-codes:\n", argv[0]);
          printf("\n  1 : Help called\n");
          printf("  2 : Unknown option.\n");
          printf("  3 : Too much parameters\n");
          printf("  4 : Error while opening FILE.\n\n");
          return 1;
        }
        else
        {
          if (!strcmp(argv[1], "-RN"))
          {
            printf("  The original name of this tool is cdump, the revision is 1.3.\n");
            return 0xff;
          }
          else
          {
            fprintf(stderr, "%s: Error: Unknown option.\n", argv[0]);
            fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
            return 2;
          }
        }
      }
    }
    else
    {
      fprintf(stderr, "%s: Error: Too much parameters.\n", argv[0]);
      fprintf(stderr, "Try %s --help for usage information.\n", argv[0]);
      return 3;
    }
  }
  if(argc==1) {
    f=stdin;
  }
  else {
    if (!(f=(fopen(argv[1], "r")))) {
      fprintf(stderr, "%s: Error while opening %s.\n", argv[0], argv[1]);
      return 4;
    }
  }
  while (c!=EOF) {
    strcpy(sum, "................");
    printf("%8.8x:", count);
    count+=0x10;
    for (l=0; l!=0x10; l++)
    {
      c=fgetc(f);
      if (c!=EOF)
      {
        printf("%3.2x", (int)c);
        if ((c<0x20) | ((c>0x7e)))
        {
          c=46;
        }
        sum[l]=c;
      }
      else
      {
        printf ("   ");
        sum[l]=0x20;
      }
    }
    printf (" %16.16s\n", sum);
  }   
  fclose(f);

  return 0;
}
