/************************************************************************
 * NCSA HTTPd Server
 * Software Development Group
 * National Center for Supercomputing Applications
 * University of Illinois at Urbana-Champaign
 * 605 E. Springfield, Champaign, IL 61820
 * httpd@ncsa.uiuc.edu
 *
 * Copyright  (C)  1995, Board of Trustees of the University of Illinois
 *
 ************************************************************************
 *
 * env.h,v 1.7 1995/11/14 16:35:01 blong Exp
 *
 ************************************************************************
 *
 *env.h,v
 *Revision 1.7  1995/11/14 16:35:01  blong
 *1.5a
 *
 * Revision 1.6  1995/08/18  15:37:00  blong
 * 1.5b3 Final
 *
 * Revision 1.5  1995/08/17  17:53:46  blong
 * Added support for Linux FD_PASS
 * Added NIS support
 * fixed array bounds write in env.c
 * various portability fixes
 * added ability to KEEP_ENV and KEEP_AUTH in continue_request
 *
 * Revision 1.4  1995/08/04  16:55:13  guillory
 * Changes to allow fewer realloc calls in merge_header SSG 8/4/95
 *
 * Revision 1.3  1995/07/25  06:43:06  blong
 * Various code cleaning exercises, including commenting all #endif's
 *
 * Revision 1.2  1995/07/17  22:45:06  blong
 * 1.5 Copyright Information
 *
 * Revision 1.1  1995/06/27  01:20:36  blong
 * Rewrite of env handling routines (Added to per_request structure)
 *
 *
 * env.h contains:
 *	All functions for dealing with the environment array.
 *	
 */

#ifndef _ENV_H_
#define _ENV_H_ 1

/* globals defined in this module */

/* Numbers to increase env array by
      These settings might affect performance quite a bit, should look into
      tuning them 
      */
#define ENV_BEG_SIZE 25
#define ENV_INC_SIZE 5
#define BIG_ENV_VAR_LEN 1024

/* function defined in this module */
int make_env_str(per_request *reqInfo, char *name, char *value);
int merge_header(per_request *reqInfo, char *h, char *v);
void free_env(per_request *reqInfo);
int replace_env_str(per_request *reqInfo, char *name, char *value);

#endif /* _ENV_H_ */

