/************************************************************************
 * NCSA HTTPd Server
 * Software Development Group
 * National Center for Supercomputing Applications
 * University of Illinois at Urbana-Champaign
 * 605 E. Springfield, Champaign, IL 61820
 * httpd@ncsa.uiuc.edu
 *
 * Copyright  (C)  1995, Board of Trustees of the University of Illinois
 *
 ************************************************************************
 *
 *env.c,v 1.16 1995/11/14 16:34:59 blong Exp
 *env.c,v
 *Revision 1.16  1995/11/14 16:34:59  blong
 *1.5a
 *
 * Revision 1.15  1995/11/03  21:56:52  blong
 * Various fixes for the final
 *
 * Revision 1.14  1995/10/06  19:15:15  blong
 * various fixes for 1.5b6, including:
 *   CoreDirectory directive added
 *   LogType now LogOptions
 *   multiple fixes to ErrorDocument in virtualhost configuration
 *   preliminary HTTP/1.1 host: matching
 *   LOCAL hack
 *   SERVER_ADMIN CGI variable
 *
 * Revision 1.13  1995/09/21  22:50:31  blong
 * General fixes for 1.5b5
 *
 * Revision 1.12  1995/08/18  05:19:48  blong
 * Fixed portability issues for QNX, ATT, ConvexOS, etc.
 *
 * Revision 1.11  1995/08/17  17:53:45  blong
 * Added support for Linux FD_PASS
 * Added NIS support
 * fixed array bounds write in env.c
 * various portability fixes
 * added ability to KEEP_ENV and KEEP_AUTH in continue_request
 *
 * Revision 1.10  1995/08/05  16:35:15  guillory
 * Put multiple referer ignore in. SSG 8/5/95
 *
 * Revision 1.9  1995/08/04  16:55:12  guillory
 * Changes to allow fewer realloc calls in merge_header SSG 8/4/95
 *
 * Revision 1.8  1995/08/04  14:58:19  blong
 * Small fix for access (for test if none)
 * other fixes for beta 2
 *
 * Revision 1.7  1995/07/25  06:43:05  blong
 * Various code cleaning exercises, including commenting all #endif's
 *
 * Revision 1.6  1995/07/23  07:27:43  blong
 * more fixups for beta
 *
 * Revision 1.5  1995/07/21  22:38:05  blong
 * Some file renaming, moving of functions for greater modularity
 * modifications for cleaner compile with -Wall
 * no a single path for A_STD_DOCUMENT files
 *
 * Revision 1.4  1995/07/17  22:45:04  blong
 * 1.5 Copyright Information
 *
 * Revision 1.3  1995/07/09  20:37:16  guillory
 * Merged blong and sguillory changes - buffered I/O SSG 7/9/95
 *
 * Revision 1.2  1995/06/27  01:20:34  blong
 * Rewrite of env handling routines (Added to per_request structure)
 *
 * Revision 1.1  1995/06/26  23:23:22  blong
 * New module for dealing with the environment
 *
 *
 * env.c contains:
 *	All functions for dealing with the environment array.
 *	
 */

#include "config.h"
#include "portability.h"

#ifndef NO_STDLIB_H 
# include <stdlib.h>
#endif /* NO_STDLIB_H */
#include <string.h>
#include "constants.h"
#include "env.h"
#include "http_log.h"

/* Older version, required external help.  Newer version should be self 
   contained for easier extensibility */

/* This will change the value of an environment variable to *value
   if found.  Returns TRUE if the replace took place, FALSE otherwise */

int  replace_env_str(per_request *reqInfo, char *name, char *value)
{
    register int i, len;
 
    for (i = 0, len = strlen(name); reqInfo->env[i]; i++) {
	if (strncmp(reqInfo->env[i], name, len) == 0) {
	    free(reqInfo->env[i]);
	    if (i < reqInfo->num_env) {
		reqInfo->env[i] = reqInfo->env[--(reqInfo->num_env)];
		reqInfo->env_len[i] = reqInfo->env_len[reqInfo->num_env];
		reqInfo->env[reqInfo->num_env] = NULL;
	    } 
	    else {
		reqInfo->env[i] = NULL;
		reqInfo->num_env--;
	    }
	    make_env_str(reqInfo, name, value);
	    return TRUE;
	}
    }
    return FALSE;
}

/* Go down the array of environment variables, free'ing as you go */

void free_env(per_request *reqInfo) {
    int x;
    
    for(x=0;reqInfo->env[x];x++)
        free(reqInfo->env[x]);
    free(reqInfo->env);
    free(reqInfo->env_len);
    reqInfo->env = NULL;
}


/* If the environment variable has already been set, this will append
   the value to it, of the form "name=old, new" 
   Assumes that "header" is a pointer to a string that is longer than
   the string it contains
*/

int merge_header(per_request *reqInfo, char *header, char *value) 
{
    register int l,lt;
    int len, ndx;
    char **t;
    
    len = strlen(value);

    for(l=0;header[l];++l);
    header[l] = '=';
    header[++l] = '\0';

    for(ndx = 0, t=reqInfo->env; *t; ++t, ndx++) {
        if(!strncmp(*t,header,l)) {
            lt = strlen(*t);
	    if ((lt + len + 2) > reqInfo->env_len[ndx]) {
		int n = reqInfo->env_len[ndx] / BIG_ENV_VAR_LEN + 1;
		if(!(*t = (char *) realloc(*t,n * BIG_ENV_VAR_LEN*sizeof(char))))
		    die(reqInfo, SC_NO_MEMORY,"merge_header");
		reqInfo->env_len[ndx] = n * BIG_ENV_VAR_LEN;
	    }
            (*t)[lt++] = ',';
            (*t)[lt++] = ' ';
            strcpy(&((*t)[lt]),value);
            return 1;
        }
    }
    header[l-1] = '\0';
    return 0;
}

/* make_env_str will add the environment variable name=value to 
   the environment array of a per_request structure.  It will also
   auto grow the structure as necessary using ENV_BEG_SIZE and ENV_INC_SIZE */

int make_env_str(per_request *reqInfo, char *name, char *value) 
{
    int n;

    if (reqInfo->env == NULL) {
	if (!(reqInfo->env = (char **) malloc(ENV_BEG_SIZE * sizeof(char *)))
	    || !(reqInfo->env_len = (int*) malloc(ENV_BEG_SIZE * sizeof(int))))
	    die(reqInfo,SC_NO_MEMORY,"make_env_str:malloc");
	reqInfo->max_env = ENV_BEG_SIZE;
    }
    if ((reqInfo->num_env+1) >= reqInfo->max_env) {
	if (!(reqInfo->env = (char **) realloc(reqInfo->env, 
	       ((reqInfo->max_env+ENV_INC_SIZE) * sizeof(char *)))) 
	    || !(reqInfo->env_len = (int*) realloc(reqInfo->env_len, 
			(reqInfo->max_env + ENV_INC_SIZE) * sizeof(int))))
	    die(reqInfo,SC_NO_MEMORY,"make_env_str:realloc");
	reqInfo->max_env += ENV_INC_SIZE;
    }
    if (!(reqInfo->env[reqInfo->num_env] = 
	  (char *) malloc(n = (strlen(name) + strlen(value) + 2))))
	die(reqInfo,SC_NO_MEMORY,"make_env_str:add");
    strcpy(reqInfo->env[reqInfo->num_env], name);
    strcat(reqInfo->env[reqInfo->num_env],"=");
    strcat(reqInfo->env[reqInfo->num_env],value);
    reqInfo->env_len[reqInfo->num_env] = n;
  
    reqInfo->num_env++;
    reqInfo->env[reqInfo->num_env] = NULL; 

    return 1;
}

/* Debugging dump of environment array */
/*
void print_env (FILE* fp, char** env)
{
    int n = 0;
    while (env[n]) {
	fprintf (fp, "Var %d: %s\n", n, env[n]);
	n++;
    }
}
*/
