/* ====================================================================
 * Copyright (c) 1995-1998 The Apache Group.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * 4. The names "Apache Server" and "Apache Group" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    apache@apache.org.
 *
 * 5. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the Apache Group
 *    for use in the Apache HTTP server project (http://www.apache.org/)."
 *
 * THIS SOFTWARE IS PROVIDED BY THE APACHE GROUP ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE APACHE GROUP OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Group and was originally based
 * on public domain software written at the National Center for
 * Supercomputing Applications, University of Illinois, Urbana-Champaign.
 * For more information on the Apache Group and the Apache HTTP server
 * project, please see <http://www.apache.org/>.
 *
 */

#ifndef APACHE_HTTPD_H
#define APACHE_HTTPD_H

/*
 * httpd.h: header for simple (ha! not anymore) http daemon
 */

/* Headers in which EVERYONE has an interest... */

#include "conf.h"
#include "alloc.h"
#include "buff.h"
#include "ap.h"

/* ----------------------------- config dir ------------------------------ */

/* Define this to be the default server home dir. Anything later in this
 * file with a relative pathname will have this added.
 */
#ifndef HTTPD_ROOT
#ifdef __EMX__
/* Set default for OS/2 file system */
#define HTTPD_ROOT "/os2httpd"
#elif defined(WIN32)
/* Set default for Windows file system */
#define HTTPD_ROOT "/apache"
#else
#define HTTPD_ROOT "/usr/local/apache"
#endif
#endif /* HTTPD_ROOT */

/* Root of server */
#ifndef DOCUMENT_LOCATION
#ifdef __EMX__
/* Set default for OS/2 file system */
#define DOCUMENT_LOCATION "/os2httpd/docs"
#else
#define DOCUMENT_LOCATION "/usr/local/apache/htdocs"
#endif
#endif /* DOCUMENT_LOCATION */

/* Max. number of dynamically loaded modules */
#ifndef DYNAMIC_MODULE_LIMIT
#define DYNAMIC_MODULE_LIMIT 64
#endif

/* Default administrator's address */
#define DEFAULT_ADMIN "[no address given]"

/* 
 * --------- You shouldn't have to edit anything below this line ----------
 *
 * Any modifications to any defaults not defined above should be done in the 
 * respective config. file. 
 *
 */


/* -- Internal representation for a HTTP protocol number, e.g., HTTP/1.1 -- */

#define HTTP_VERSION(major,minor) (1000*(major)+(minor))


/* -------------- Port number for server running standalone --------------- */

#define DEFAULT_HTTP_PORT	80
#define DEFAULT_HTTPS_PORT	443
#define is_default_port(port,r)	((port) == default_port(r))
#define http_method(r)	"http"
#define	default_port(r)	DEFAULT_HTTP_PORT

/* --------- Default user name and group name running standalone ---------- */
/* --- These may be specified as numbers by placing a # before a number --- */

#ifndef DEFAULT_USER
#define DEFAULT_USER "#-1"
#endif
#ifndef DEFAULT_GROUP
#define DEFAULT_GROUP "#-1"
#endif

/* The name of the log files */
#ifndef DEFAULT_XFERLOG
#ifdef __EMX__
/* Set default for OS/2 file system */
#define DEFAULT_XFERLOG "logs/access.log"
#else
#define DEFAULT_XFERLOG "logs/access_log"
#endif
#endif /* DEFAULT_XFERLOG */

#ifndef DEFAULT_ERRORLOG
#ifdef __EMX__
/* Set default for OS/2 file system */
#define DEFAULT_ERRORLOG "logs/error.log"
#else
#define DEFAULT_ERRORLOG "logs/error_log"
#endif
#endif /* DEFAULT_ERRORLOG */

#ifndef DEFAULT_PIDLOG
#define DEFAULT_PIDLOG "logs/httpd.pid"
#endif
#ifndef DEFAULT_SCOREBOARD
#define DEFAULT_SCOREBOARD "logs/apache_runtime_status"
#endif
#ifndef DEFAULT_LOCKFILE
#define DEFAULT_LOCKFILE "logs/accept.lock"
#endif

/* Define this to be what your HTML directory content files are called */
#ifndef DEFAULT_INDEX
#define DEFAULT_INDEX "index.html"
#endif

/* Define this to 1 if you want fancy indexing, 0 otherwise */
#ifndef DEFAULT_INDEXING
#define DEFAULT_INDEXING 0
#endif

/* Define this to be what type you'd like returned for files with unknown */
/* suffixes */
#ifndef DEFAULT_CONTENT_TYPE
#define DEFAULT_CONTENT_TYPE "text/plain"
#endif

/* Define this to be what your per-directory security files are called */
#ifndef DEFAULT_ACCESS_FNAME
#ifdef __EMX__
/* Set default for OS/2 file system */
#define DEFAULT_ACCESS_FNAME "htaccess"
#else
#define DEFAULT_ACCESS_FNAME ".htaccess"
#endif
#endif /* DEFAULT_ACCESS_FNAME */

/* The name of the server config file */
#ifndef SERVER_CONFIG_FILE
#define SERVER_CONFIG_FILE "conf/httpd.conf"
#endif

/* The name of the document config file */
#ifndef RESOURCE_CONFIG_FILE
#define RESOURCE_CONFIG_FILE "conf/srm.conf"
#endif

/* The name of the MIME types file */
#ifndef TYPES_CONFIG_FILE
#define TYPES_CONFIG_FILE "conf/mime.types"
#endif

/* The name of the access file */
#ifndef ACCESS_CONFIG_FILE
#define ACCESS_CONFIG_FILE "conf/access.conf"
#endif

/* Whether we should enable rfc1413 identity checking */
#ifndef DEFAULT_RFC1413
#define DEFAULT_RFC1413 0
#endif
/* The default directory in user's home dir */
#ifndef DEFAULT_USER_DIR
#define DEFAULT_USER_DIR "public_html"
#endif

/* The default path for CGI scripts if none is currently set */
#ifndef DEFAULT_PATH
#define DEFAULT_PATH "/bin:/usr/bin:/usr/ucb:/usr/bsd:/usr/local/bin"
#endif

/* The path to the Bourne shell, for parsed docs */
#ifndef SHELL_PATH
#if defined(__EMX__) || defined(WIN32)
/* Set default for OS/2 file system */
#define SHELL_PATH "CMD.EXE"
#else
#define SHELL_PATH "/bin/sh"
#endif
#endif /* SHELL_PATH */

/* The path to the suExec wrapper, can be overridden in Configuration */
#ifndef SUEXEC_BIN
#define SUEXEC_BIN "/usr/local/apache/sbin/suexec"
#endif

/* The default string lengths */
#define MAX_STRING_LEN HUGE_STRING_LEN
#define HUGE_STRING_LEN 8192

/* The timeout for waiting for messages */
#ifndef DEFAULT_TIMEOUT
#define DEFAULT_TIMEOUT 300
#endif

/* The timeout for waiting for keepalive timeout until next request */
#ifndef DEFAULT_KEEPALIVE_TIMEOUT
#define DEFAULT_KEEPALIVE_TIMEOUT 15
#endif

/* The number of requests to entertain per connection */
#ifndef DEFAULT_KEEPALIVE
#define DEFAULT_KEEPALIVE 100
#endif

/* The size of the server's internal read-write buffers */
#define IOBUFSIZE 8192

/* Number of servers to spawn off by default --- also, if fewer than
 * this free when the caretaker checks, it will spawn more.
 */
#ifndef DEFAULT_START_DAEMON
#define DEFAULT_START_DAEMON 5
#endif

/* Maximum number of *free* server processes --- more than this, and
 * they will die off.
 */

#ifndef DEFAULT_MAX_FREE_DAEMON
#define DEFAULT_MAX_FREE_DAEMON 10
#endif

/* Minimum --- fewer than this, and more will be created */

#ifndef DEFAULT_MIN_FREE_DAEMON
#define DEFAULT_MIN_FREE_DAEMON 5
#endif

/* Limit on the total --- clients will be locked out if more servers than
 * this are needed.  It is intended solely to keep the server from crashing
 * when things get out of hand.
 *
 * We keep a hard maximum number of servers, for two reasons --- first off,
 * in case something goes seriously wrong, we want to stop the fork bomb
 * short of actually crashing the machine we're running on by filling some
 * kernel table.  Secondly, it keeps the size of the scoreboard file small
 * enough that we can read the whole thing without worrying too much about
 * the overhead.
 */
#ifndef HARD_SERVER_LIMIT
#define HARD_SERVER_LIMIT 256
#endif

/*
 * (Unix, OS/2 only)
 * Interval, in microseconds, between scoreboard maintenance.  During
 * each scoreboard maintenance cycle the parent decides if it needs to
 * spawn a new child (to meet MinSpareServers requirements), or kill off
 * a child (to meet MaxSpareServers requirements).  It will only spawn or
 * kill one child per cycle.  Setting this too low will chew cpu.  The
 * default is probably sufficient for everyone.  But some people may want
 * to raise this on servers which aren't dedicated to httpd and where they
 * don't like the httpd waking up each second to see what's going on.
 */
#ifndef SCOREBOARD_MAINTENANCE_INTERVAL
#define SCOREBOARD_MAINTENANCE_INTERVAL 1000000
#endif

/* Number of requests to try to handle in a single process.  If <= 0,
 * the children don't die off.  That's the default here, since I'm still
 * interested in finding and stanching leaks.
 */

#ifndef DEFAULT_MAX_REQUESTS_PER_CHILD
#define DEFAULT_MAX_REQUESTS_PER_CHILD 0
#endif

#ifndef DEFAULT_THREADS_PER_CHILD
#define DEFAULT_THREADS_PER_CHILD 50
#endif
#ifndef DEFAULT_EXCESS_REQUESTS_PER_CHILD
#define DEFAULT_EXCESS_REQUESTS_PER_CHILD 0
#endif

/* The maximum length of the queue of pending connections, as defined
 * by listen(2).  Under some systems, it should be increased if you
 * are experiencing a heavy TCP SYN flood attack.
 *
 * It defaults to 511 instead of 512 because some systems store it 
 * as an 8-bit datatype; 512 truncated to 8-bits is 0, while 511 is 
 * 255 when truncated.
 */

#ifndef DEFAULT_LISTENBACKLOG
#define DEFAULT_LISTENBACKLOG 511
#endif

/* If you have altered Apache and wish to change the SERVER_VERSION
 * identifier below, please keep to the HTTP specification.  This states that
 * the identification string should consist of product tokens with an optional
 * slash and version designator.  Sub-products which form a significant part 
 * of the application can be listed, separated by whitespace, by adding
 * their product tokens to EXTRA_CFLAGS in the Configuration file like so.
 *
 * EXTRA_CFLAGS="-DSERVER_SUBVERSION="MrWidget/0.1-alpha"
 *
 * The tokens are listed in order of their significance for identifying the
 * application.
 *
 * "Product tokens should be short and to the point -- use of them for 
 * advertizing or other non-essential information is explicitly forbidden."
 *
 * Example: "Apache/1.1.0 MrWidget/0.1-alpha" 
 */

#define SERVER_BASEVERSION "Apache/1.3b5"	/* SEE COMMENTS ABOVE */
#ifdef SERVER_SUBVERSION
#define SERVER_VERSION	SERVER_BASEVERSION " " SERVER_SUBVERSION
#else
#define SERVER_VERSION	SERVER_BASEVERSION
#endif
extern MODULE_VAR_EXPORT const char SERVER_BUILT[];

/* Numeric release version identifier: major minor bugfix betaseq
 * Always increases along the same track as the source branch.
 */
#define APACHE_RELEASE 1030005

#define SERVER_PROTOCOL "HTTP/1.1"
#ifndef SERVER_SUPPORT
#define SERVER_SUPPORT "http://www.apache.org/"
#endif

#define DECLINED -1		/* Module declines to handle */
#define DONE -2			/* Module has served the response completely 
				 *  - it's safe to die() with no more output
				 */
#define OK 0			/* Module has handled this stage. */


/* ----------------------- HTTP Status Codes  ------------------------- */

#define RESPONSE_CODES 38

#define HTTP_CONTINUE                      100
#define HTTP_SWITCHING_PROTOCOLS           101
#define HTTP_OK                            200
#define HTTP_CREATED                       201
#define HTTP_ACCEPTED                      202
#define HTTP_NON_AUTHORITATIVE             203
#define HTTP_NO_CONTENT                    204
#define HTTP_RESET_CONTENT                 205
#define HTTP_PARTIAL_CONTENT               206
#define HTTP_MULTIPLE_CHOICES              300
#define HTTP_MOVED_PERMANENTLY             301
#define HTTP_MOVED_TEMPORARILY             302
#define HTTP_SEE_OTHER                     303
#define HTTP_NOT_MODIFIED                  304
#define HTTP_USE_PROXY                     305
#define HTTP_BAD_REQUEST                   400
#define HTTP_UNAUTHORIZED                  401
#define HTTP_PAYMENT_REQUIRED              402
#define HTTP_FORBIDDEN                     403
#define HTTP_NOT_FOUND                     404
#define HTTP_METHOD_NOT_ALLOWED            405
#define HTTP_NOT_ACCEPTABLE                406
#define HTTP_PROXY_AUTHENTICATION_REQUIRED 407
#define HTTP_REQUEST_TIME_OUT              408
#define HTTP_CONFLICT                      409
#define HTTP_GONE                          410
#define HTTP_LENGTH_REQUIRED               411
#define HTTP_PRECONDITION_FAILED           412
#define HTTP_REQUEST_ENTITY_TOO_LARGE      413
#define HTTP_REQUEST_URI_TOO_LARGE         414
#define HTTP_UNSUPPORTED_MEDIA_TYPE        415
#define HTTP_INTERNAL_SERVER_ERROR         500
#define HTTP_NOT_IMPLEMENTED               501
#define HTTP_BAD_GATEWAY                   502
#define HTTP_SERVICE_UNAVAILABLE           503
#define HTTP_GATEWAY_TIME_OUT              504
#define HTTP_VERSION_NOT_SUPPORTED         505
#define HTTP_VARIANT_ALSO_VARIES           506

#define DOCUMENT_FOLLOWS    HTTP_OK
#define PARTIAL_CONTENT     HTTP_PARTIAL_CONTENT
#define MULTIPLE_CHOICES    HTTP_MULTIPLE_CHOICES
#define MOVED               HTTP_MOVED_PERMANENTLY
#define REDIRECT            HTTP_MOVED_TEMPORARILY
#define USE_LOCAL_COPY      HTTP_NOT_MODIFIED
#define BAD_REQUEST         HTTP_BAD_REQUEST
#define AUTH_REQUIRED       HTTP_UNAUTHORIZED
#define FORBIDDEN           HTTP_FORBIDDEN
#define NOT_FOUND           HTTP_NOT_FOUND
#define METHOD_NOT_ALLOWED  HTTP_METHOD_NOT_ALLOWED
#define NOT_ACCEPTABLE      HTTP_NOT_ACCEPTABLE
#define LENGTH_REQUIRED     HTTP_LENGTH_REQUIRED
#define PRECONDITION_FAILED HTTP_PRECONDITION_FAILED
#define SERVER_ERROR        HTTP_INTERNAL_SERVER_ERROR
#define NOT_IMPLEMENTED     HTTP_NOT_IMPLEMENTED
#define BAD_GATEWAY         HTTP_BAD_GATEWAY
#define VARIANT_ALSO_VARIES HTTP_VARIANT_ALSO_VARIES

#define is_HTTP_INFO(x)         (((x) >= 100)&&((x) < 200))
#define is_HTTP_SUCCESS(x)      (((x) >= 200)&&((x) < 300))
#define is_HTTP_REDIRECT(x)     (((x) >= 300)&&((x) < 400))
#define is_HTTP_ERROR(x)        (((x) >= 400)&&((x) < 600))
#define is_HTTP_CLIENT_ERROR(x) (((x) >= 400)&&((x) < 500))
#define is_HTTP_SERVER_ERROR(x) (((x) >= 500)&&((x) < 600))

#define status_drops_connection(x) (((x) == HTTP_BAD_REQUEST)           || \
                                    ((x) == HTTP_REQUEST_TIME_OUT)      || \
                                    ((x) == HTTP_LENGTH_REQUIRED)       || \
                                    ((x) == HTTP_REQUEST_ENTITY_TOO_LARGE) || \
                                    ((x) == HTTP_REQUEST_URI_TOO_LARGE) || \
                                    ((x) == HTTP_INTERNAL_SERVER_ERROR) || \
                                    ((x) == HTTP_SERVICE_UNAVAILABLE))


#define METHODS 8
#define M_GET 0
#define M_PUT 1
#define M_POST 2
#define M_DELETE 3
#define M_CONNECT 4
#define M_OPTIONS 5
#define M_TRACE 6
#define M_INVALID 7

#define CGI_MAGIC_TYPE "application/x-httpd-cgi"
#define INCLUDES_MAGIC_TYPE "text/x-server-parsed-html"
#define INCLUDES_MAGIC_TYPE3 "text/x-server-parsed-html3"
#ifdef CHARSET_EBCDIC
#define ASCIITEXT_MAGIC_TYPE_PREFIX "text/x-ascii-" /* Text files whose content-type starts with this are passed thru unconverted */
#endif /*CHARSET_EBCDIC*/
#define MAP_FILE_MAGIC_TYPE "application/x-type-map"
#define ASIS_MAGIC_TYPE "httpd/send-as-is"
#define DIR_MAGIC_TYPE "httpd/unix-directory"
#define STATUS_MAGIC_TYPE "application/x-httpd-status"

/* Just in case your linefeed isn't the one the other end is expecting. */
#ifndef CHARSET_EBCDIC
#define LF 10
#define CR 13
#else /* CHARSET_EBCDIC */
#include "ebcdic.h"
/* OSD_POSIX uses the EBCDIC charset. The transition ASCII->EBCDIC is done in
 * the buff package (bread/bputs/bwrite), so everywhere else, we use
 * "native EBCDIC" CR and NL characters. These are therefore defined as
 * '\r' and '\n'.
 * NB: this is not the whole truth - sometimes \015 and \012 are contained
 * in literal (EBCDIC!) strings, so these are not converted but passed.
 */
#define CR '\r'
#define LF '\n'
#endif /* CHARSET_EBCDIC */

/* Possible values for request_rec.read_body (set by handling module):
 *    REQUEST_NO_BODY          Send 413 error if message has any body
 *    REQUEST_CHUNKED_ERROR    Send 411 error if body without Content-Length
 *    REQUEST_CHUNKED_DECHUNK  If chunked, remove the chunks for me.
 *    REQUEST_CHUNKED_PASS     Pass the chunks to me without removal.
 */
#define REQUEST_NO_BODY          0
#define REQUEST_CHUNKED_ERROR    1
#define REQUEST_CHUNKED_DECHUNK  2
#define REQUEST_CHUNKED_PASS     3

/* Things which may vary per file-lookup WITHIN a request ---
 * e.g., state of MIME config.  Basically, the name of an object, info
 * about the object, and any other info we may ahve which may need to
 * change as we go poking around looking for it (e.g., overridden by
 * .htaccess files).
 *
 * Note how the default state of almost all these things is properly
 * zero, so that allocating it with pcalloc does the right thing without
 * a whole lot of hairy initialization... so long as we are willing to
 * make the (fairly) portable assumption that the bit pattern of a NULL
 * pointer is, in fact, zero.
 */

/* This represents the result of calling htaccess; these are cached for
 * each request.
 */
struct htaccess_result {
    char *dir;			/* the directory to which this applies */
    int override;		/* the overrides allowed for the .htaccess file */
    void *htaccess;		/* the configuration directives */
/* the next one, or NULL if no more; N.B. never change this */
    const struct htaccess_result *next;
};

typedef struct conn_rec conn_rec;
typedef struct server_rec server_rec;
typedef struct request_rec request_rec;
typedef struct listen_rec listen_rec;

struct request_rec {

    pool *pool;
    conn_rec *connection;
    server_rec *server;

    request_rec *next;		/* If we wind up getting redirected,
				 * pointer to the request we redirected to.
				 */
    request_rec *prev;		/* If this is an internal redirect,
				 * pointer to where we redirected *from*.
				 */

    request_rec *main;		/* If this is a sub_request (see request.h) 
				 * pointer back to the main request.
				 */

    /* Info about the request itself... we begin with stuff that only
     * protocol.c should ever touch...
     */

    char *the_request;		/* First line of request, so we can log it */
    int assbackwards;		/* HTTP/0.9, "simple" request */
    int proxyreq;		/* A proxy request */
    int header_only;		/* HEAD request, as opposed to GET */
    char *protocol;		/* Protocol, as given to us, or HTTP/0.9 */
    int proto_num;		/* Number version of protocol; 1.1 = 1001 */
    char *hostname;		/* Host, as set by full URI or Host: */
    int hostlen;		/* Length of http://host:port in full URI */

    time_t request_time;	/* When the request started */

    char *status_line;		/* Status line, if set by script */
    int status;			/* In any case */

    /* Request method, two ways; also, protocol, etc..  Outside of protocol.c,
     * look, but don't touch.
     */

    char *method;		/* GET, HEAD, POST, etc. */
    int method_number;		/* M_GET, M_POST, etc. */
    int allowed;		/* Allowed methods - for 405, OPTIONS, etc */

    int sent_bodyct;		/* byte count in stream is for body */
    long bytes_sent;		/* body byte count, for easy access */
    time_t mtime;		/* Time the resource was last modified */

    /* HTTP/1.1 connection-level features */

    int chunked;		/* sending chunked transfer-coding */
    int byterange;		/* number of byte ranges */
    char *boundary;		/* multipart/byteranges boundary */
    char *range;		/* The Range: header */
    long clength;		/* The "real" content length */

    long remaining;		/* bytes left to read */
    long read_length;		/* bytes that have been read */
    int read_body;		/* how the request body should be read */
    int read_chunked;		/* reading chunked transfer-coding */

    /* MIME header environments, in and out.  Also, an array containing
     * environment variables to be passed to subprocesses, so people can
     * write modules to add to that environment.
     *
     * The difference between headers_out and err_headers_out is that the
     * latter are printed even on error, and persist across internal redirects
     * (so the headers printed for ErrorDocument handlers will have them).
     *
     * The 'notes' table is for notes from one module to another, with no
     * other set purpose in mind...
     */

    table *headers_in;
    table *headers_out;
    table *err_headers_out;
    table *subprocess_env;
    table *notes;

    char *content_type;		/* Break these out --- we dispatch on 'em */
    char *handler;		/* What we *really* dispatch on           */

    char *content_encoding;
    char *content_language;	/* for back-compat. only -- do not use */
    array_header *content_languages;	/* array of (char*) */

    int no_cache;
    int no_local_copy;

    /* What object is being requested (either directly, or via include
     * or content-negotiation mapping).
     */

    char *uri;			/* complete URI for a proxy req, or
				   URL path for a non-proxy req */
    char *filename;
    char *path_info;
    char *args;			/* QUERY_ARGS, if any */
    struct stat finfo;		/* ST_MODE set to zero if no such file */

    /* Various other config info which may change with .htaccess files
     * These are config vectors, with one void* pointer for each module
     * (the thing pointed to being the module's business).
     */

    void *per_dir_config;	/* Options set in config files, etc. */
    void *request_config;	/* Notes on *this* request */

/*
 * a linked list of the configuration directives in the .htaccess files
 * accessed by this request.
 * N.B. always add to the head of the list, _never_ to the end.
 * that way, a sub request's list can (temporarily) point to a parent's list
 */
    const struct htaccess_result *htaccess;
};


/* Things which are per connection
 */

struct conn_rec {

    pool *pool;
    server_rec *server;
    server_rec *base_server;	/* Physical vhost this conn come in on */
    void *vhost_lookup_data;	/* used by http_vhost.c */

    /* Information about the connection itself */

    int child_num;		/* The number of the child handling conn_rec */
    BUFF *client;		/* Connection to the guy */

    /* Who is the client? */

    struct sockaddr_in local_addr;	/* local address */
    struct sockaddr_in remote_addr;	/* remote address */
    char *remote_ip;		/* Client's IP address */
    char *remote_host;		/* Client's DNS name, if known.
				 * NULL if DNS hasn't been checked,
				 * "" if it has and no address was found.
				 * N.B. Only access this though
				 * get_remote_host() */
    char *remote_logname;	/* Only ever set if doing rfc1413 lookups.
				 * N.B. Only access this through
				 * get_remote_logname() */
    char *user;			/* If an authentication check was made,
				 * this gets set to the user name.  We assume
				 * that there's only one user per connection(!)
				 */
    char *auth_type;		/* Ditto. */

    unsigned aborted:1;		/* Are we still talking? */
    int keepalive:2;		/* Are we using HTTP Keep-Alive?
				 * -1 fatal error, 0 undecided, 1 yes */
    unsigned keptalive:1;	/* Did we use HTTP Keep-Alive? */
    int double_reverse:2;	/* have we done double-reverse DNS?
				 * -1 yes/failure, 0 not yet, 1 yes/success */
    int keepalives;		/* How many times have we used it? */
};

/* Per-vhost config... */

/* The address 255.255.255.255, when used as a virtualhost address,
 * will become the "default" server when the ip doesn't match other vhosts.
 */
#define DEFAULT_VHOST_ADDR 0xfffffffful

typedef struct server_addr_rec server_addr_rec;
struct server_addr_rec {
    server_addr_rec *next;
    struct in_addr host_addr;	/* The bound address, for this server */
    unsigned short host_port;	/* The bound port, for this server */
    char *virthost;		/* The name given in <VirtualHost> */
};

struct server_rec {

    server_rec *next;

    /* Full locations of server config info */

    char *srm_confname;
    char *access_confname;

    /* Contact information */

    char *server_admin;
    char *server_hostname;
    unsigned short port;	/* for redirects, etc. */

    /* Log files --- note that transfer log is now in the modules... */

    char *error_fname;
    FILE *error_log;
    int loglevel;

    /* Module-specific configuration for server, and defaults... */

    int is_virtual;		/* true if this is the virtual server */
    void *module_config;	/* Config vector containing pointers to
				 * modules' per-server config structures.
				 */
    void *lookup_defaults;	/* MIME type info, etc., before we start
				 * checking per-directory info.
				 */
    /* Transaction handling */

    server_addr_rec *addrs;
    int timeout;		/* Timeout, in seconds, before we give up */
    int keep_alive_timeout;	/* Seconds we'll wait for another request */
    int keep_alive_max;		/* Maximum requests per connection */
    int keep_alive;		/* Use persistent connections? */
    int send_buffer_size;	/* size of TCP send buffer (in bytes) */

    char *path;			/* Pathname for ServerPath */
    int pathlen;		/* Length of path */

    char *names;		/* Wildcarded names for ServerAlias servers */

    uid_t server_uid;		/* effective user id when calling exec wrapper */
    gid_t server_gid;		/* effective group id when calling exec wrapper */
};

/* These are more like real hosts than virtual hosts */
struct listen_rec {
    listen_rec *next;
    struct sockaddr_in local_addr;	/* local IP address and port */
    int fd;
    int used;			/* Only used during restart */
/* more stuff here, like which protocol is bound to the port */
};

/* Prototypes for utilities... util.c.
 */

/* Time */
extern MODULE_VAR_EXPORT const char month_snames[12][4];

API_EXPORT(struct tm *) get_gmtoff(int *tz);
API_EXPORT(char *) get_time(void);
API_EXPORT(char *) ht_time(pool *p, time_t t, const char *fmt, int gmt);
API_EXPORT(char *) gm_timestr_822(pool *p, time_t t);

/* String handling. The *_nc variants allow you to use non-const char **s as
   arguments (unfortunately C won't automatically convert a char ** to a const
   char **) */

API_EXPORT(char *) getword(pool *p, const char **line, char stop);
API_EXPORT(char *) getword_nc(pool *p, char **line, char stop);
API_EXPORT(char *) getword_white(pool *p, const char **line);
API_EXPORT(char *) getword_white_nc(pool *p, char **line);
API_EXPORT(char *) getword_nulls(pool *p, const char **line, char stop);
API_EXPORT(char *) getword_nulls_nc(pool *p, char **line, char stop);
API_EXPORT(char *) getword_conf(pool *p, const char **line);
API_EXPORT(char *) getword_conf_nc(pool *p, char **line);

API_EXPORT(char *) get_token(pool *p, char **accept_line, int accept_white);
API_EXPORT(int) find_token(pool *p, const char *line, const char *tok);
API_EXPORT(int) find_last_token(pool *p, const char *line, const char *tok);

API_EXPORT(int) is_url(const char *u);
API_EXPORT(int) unescape_url(char *url);
API_EXPORT(void) no2slash(char *name);
API_EXPORT(void) getparents(char *name);
API_EXPORT(char *) escape_path_segment(pool *p, const char *s);
API_EXPORT(char *) os_escape_path(pool *p, const char *path, int partial);
#define escape_uri(ppool,path) os_escape_path(ppool,path,1)
API_EXPORT(char *) escape_html(pool *p, const char *s);
API_EXPORT(char *) construct_server(pool *p, const char *hostname,
				    unsigned port, const request_rec *r);
API_EXPORT(char *) escape_shell_cmd(pool *p, const char *s);

API_EXPORT(int) count_dirs(const char *path);
API_EXPORT(char *) make_dirstr_prefix(char *d, const char *s, int n);
API_EXPORT(char *) make_dirstr_parent(pool *p, const char *s);
/* deprecated.  The previous two routines are preferred. */
API_EXPORT(char *) make_dirstr(pool *a, const char *s, int n);
API_EXPORT(char *) make_full_path(pool *a, const char *dir, const char *f);

API_EXPORT(int) is_matchexp(const char *str);
API_EXPORT(int) strcmp_match(const char *str, const char *exp);
API_EXPORT(int) strcasecmp_match(const char *str, const char *exp);
API_EXPORT(char *) uudecode(pool *, const char *);

API_EXPORT(char *) pregsub(pool *p, const char *input, const char *source,
			   size_t nmatch, regmatch_t pmatch[]);

API_EXPORT(void) str_tolower(char *);
API_EXPORT(int) ind(const char *, char);	/* Sigh... */
API_EXPORT(int) rind(const char *, char);

API_EXPORT(char *) ap_escape_quotes (pool *p, const char *instring);

/* Common structure for reading of config files / passwd files etc. */
typedef struct {
    int (*getch) (void *param);	/* a getc()-like function */
    void *(*getstr) (void *buf, size_t bufsiz, void *param); /* a fgets()-like function */
    int (*close) (void *param);	/* a fclose()-like function */
    void *param;		/* the argument passed to getc()/close()/gets() */
    const char *name;		/* the filename / description */
    unsigned line_number;	/* current line number, starting at 1 */
} configfile_t;

/* Open a configfile_t as FILE, return open configfile_t struct pointer */
API_EXPORT(configfile_t *) pcfg_openfile(pool *p, const char *name);

/* Allocate a configfile_t handle with user defined functions and params */
API_EXPORT(configfile_t *) pcfg_open_custom(pool *p, const char *descr,
    void *param,
    int(*getc_func)(void*),
    void *(*gets_func) (void *buf, size_t bufsiz, void *param),
    int(*close_func)(void*));

/* Read one line from open configfile_t, strip LF, increase line number */
API_EXPORT(int) cfg_getline(char *buf, size_t bufsize, configfile_t *cfp);

/* Read one char from open configfile_t, increase line number upon LF */
API_EXPORT(int) cfg_getc(configfile_t *cfp);

/* Detach from open configfile_t, calling the close handler */
API_EXPORT(int) cfg_closefile(configfile_t *fp);

#ifdef NEED_STRERROR
char *strerror(int err);
#endif

/* Misc system hackery */

API_EXPORT(uid_t) uname2id(const char *name);
API_EXPORT(gid_t) gname2id(const char *name);
API_EXPORT(int) is_directory(const char *name);
API_EXPORT(int) can_exec(const struct stat *);
API_EXPORT(void) chdir_file(const char *file);

#ifndef HAVE_CANONICAL_FILENAME
#define os_canonical_filename(p,f)  (f)
#else
API_EXPORT(char *) os_canonical_filename(pool *p, const char *file);
#endif

char *get_local_host(pool *);
unsigned long get_virthost_addr(const char *hostname, unsigned short *port);

extern API_VAR_EXPORT time_t restart_time;

/*
 * Apache tries to keep all of its long term filehandles (such as log files,
 * and sockets) above this number.  This is to workaround problems in many
 * third party libraries that are compiled with a small FD_SETSIZE.  There
 * should be no reason to lower this, because it's only advisory.  If a file
 * can't be allocated above this number then it will remain in the "slack"
 * area.
 *
 * Only the low slack line is used by default.  If HIGH_SLACK_LINE is defined
 * then an attempt is also made to keep all non-FILE * files above the high
 * slack line.  This is to work around a Solaris C library limitation, where it
 * uses an unsigned char to store the file descriptor.
 */
#ifndef LOW_SLACK_LINE
#define LOW_SLACK_LINE	15
#endif
/* #define HIGH_SLACK_LINE      255 */

/*
 * The ap_slack() function takes a fd, and tries to move it above the indicated
 * line.  It returns an fd which may or may not have moved above the line, and
 * never fails.  If the high line was requested and it fails it will also try
 * the low line.
 */
#ifdef NO_SLACK
#define ap_slack(fd,line)   (fd)
#else
int ap_slack(int fd, int line);
#define AP_SLACK_LOW	1
#define AP_SLACK_HIGH	2
#endif

/*
 * Redefine assert() to something more useful for an Apache...
 */
API_EXPORT(void) log_assert(const char *szExp, const char *szFile, int nLine)
			    __attribute__((noreturn));
#define ap_assert(exp) (void)( (exp) || (log_assert(#exp, __FILE__, __LINE__), 0) )

/* The optimized timeout code only works if we're not MULTITHREAD and we're
 * also not using a scoreboard file
 */
#if !defined (MULTITHREAD) && \
    (defined (USE_MMAP_SCOREBOARD) || defined (USE_SHMGET_SCOREBOARD))
#define OPTIMIZE_TIMEOUTS
#endif

/* A set of flags which indicate places where the server should raise(SIGSTOP).
 * This is useful for debugging, because you can then attach to that process
 * with gdb and continue.  This is important in cases where one_process
 * debugging isn't possible.
 */
#define SIGSTOP_DETACH			1
#define SIGSTOP_MAKE_CHILD		2
#define SIGSTOP_SPAWN_CHILD		4
#define SIGSTOP_PIPED_LOG_SPAWN		8
#define SIGSTOP_CGI_CHILD		16

#ifdef DEBUG_SIGSTOP
extern int raise_sigstop_flags;
#define RAISE_SIGSTOP(x)	do { \
	if (raise_sigstop_flags & SIGSTOP_##x) raise(SIGSTOP);\
    } while (0)
#else
#define RAISE_SIGSTOP(x)
#endif

API_EXPORT(extern const char *) psignature(const char *prefix, request_rec *r);

#endif	/* !APACHE_HTTPD_H */
