#
# $Source: /home/nlfm/Working/Zircon/Released/lib/RCS/Undernet.tcl,v $
# $Date: 1996/08/15 10:51:30 $
# $Revision: 1.17.1.6 $
#
# Undernet specific calls - 5, 6 and 7 handle the MAP command.
#
proc irc005 {net prefix param pargs} {
    global umap
    lappend umap($net) $param
}
#
proc irc006 {net prefix param pargs} {
    global umap
    lappend umap($net) $param
}
#
proc irc007 {net prefix param pargs} {
    global umap ztrans
    if ![winfo exists [set w .@map$net]] {
	toplevel $w -class Zircon
	wm title $w "Undernet Map from [$net host]"
	wm resizable $w 1 1
	set f [frame $w.f1]
	scrollbar $f.vs -command "$f.txt yview"
	text $f.txt -yscrollcommand "$f.vs set"
	pack $f.vs -side right -fill y -expand 1
	pack $f.txt -side left -fill both -expand 1
	pack $f -fill both -expand 1
	set f [frame $w.f2]
	button $f.ok -text $ztrans(dismiss) \
	  -command "destroy .@map$net"
	button $f.map -text $ztrans(map) -command "$net q1Send MAP"
	pack $f.ok $f.map -side left -expand 1
	pack $f -fill x
    }
    $w.f1.txt delete 0.0 end
    foreach x $umap($net) { $w.f1.txt insert end "$x\n" }
    unset umap($net)
}
#
proc underList {net} {
    set min [$net minMembers]
    set max [$net maxMembers]
    set par {}
    if {$max > 0} { set par <[incr $max],}
    $net qSend LIST :$par>[incr min]
}
#
proc underSilence {net} {
    global ztrans
    mkEntryBox .@sil$net $ztrans(silence) \
      {Enter user pattern:} "{$ztrans(user) {}}" \
      "$ztrans(silence) {doSilence + $net}" \
      "$ztrans(delete) {doSilence - $net}" "$ztrans(cancel) {}"
}
#
proc doSilence {op net args} {
   if ![string match {} $args] { $net qSend SILENCE :$op[lindex $args 0] }
}
#
proc underUSilence {op net usr} {  $net qSend SILENCE :$op[$usr name] }
#
proc ircSILENCE {net prefix param pargs} {
    switch -glob -- [set v [lindex $pargs 0]] {
    -* {set txt unsilenced}
    +* {set txt silenced}
    }
    $net inform "User [string range $v 1 end] $txt."
}
