//   $Id: kvi_voice.h,v 1.2 1998/10/23 21:45:20 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_VOICE_H_INCLUDED_
#define _KVI_VOICE_H_INCLUDED_

#include "kvi_child.h"
#include <kprocess.h>
#include <qpushbutton.h>
#include <kprogress.h>

class KviInput;
class KviOptions;

class KviVoiceWnd : public KviMdiChild
{
	Q_OBJECT
public:	
	KviVoiceWnd(KviMdiManager *parent,KviFrame *frame,const char *aname,int aid);
	~KviVoiceWnd();

	KviOptions			*m_lpOpt;
	QString				m_szRemoteNick;
	QString				m_szRemoteIp;
	QTimer				*m_lpTimer;
	KProcess            *m_lpKviPhone;
	unsigned long       m_myAddress;
	QString             m_szLastIncompleteOutput;
	QPushButton         *m_lpTalk;
	bool                m_bCanTalk;
	KProgress           *m_lpProgress;
	KProgress           *m_lpSendProgress;
	QTimer              *m_lpTalkTimer;
public:
	void applyOptions();
	void doFmtOutput(int nType,const char *szFmt,...);
	void doOutput(int nType,const char *szText);
	bool requestConnection(const char *szNick);
	void acceptConnection(QString &szPort,QString &szIp,const char *szNick);
protected:
	bool startListeningKviphone();
	bool startConnectingKviphone(QString &szIp,QString &szPort);
	void processOutput(QString &szOut);
	virtual void resizeEvent(QResizeEvent *);
public slots:
	void talkinPlusPlus(); //what a funny name :)
	void closeSlot();
	void childExited(KProcess *);
	void gotStdout(KProcess *,char *buffer,int buflen);
	void talk();
	void endTalk();
};

#endif // _KVI_CHAT_H_INCLUDED_
