//   $Id: kvi_ulist.h,v 1.1 1998/09/23 12:25:38 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_ULIST_H_INCLUDED_
#define _KVI_ULIST_H_INCLUDED_

#include <qlist.h>
#include <qstring.h>

class KviUserManager{
public:
	KviUserManager();
	~KviUserManager();
public:
	QList<KviUserStruct> *m_lpUserList;
	QList<QString> *m_lpCurIgnoreList;
	QList<QString> *m_lpCurNotifyList;
public:
	void readFromFile();
	void saveToFile();
	void copyUserStruct(KviUserStruct *lpDest,KviUserStruct *lpSrc);
	void clearUserStruct(KviUserStruct *lpS);
	void addUser(KviUserStruct *lpS);
	void delUser(const char *szNick);
	KviUserStruct * getUser(const char *szNick);
private:
	void fillIgnoreList();
	void fillNotifyList();
	void cantWriteError();
	void cantReadError();
	bool readString(QFile *lpFile,QString &szString);
};

#endif //_KVI_ULIST_H_INCLUDED_
