//   $Id: kvi_uglobal.h,v 1.1 1998/10/06 15:02:56 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_UGLOBAL_H_INCLUDED_
#define _KVI_UGLOBAL_H_INCLUDED_

#include <qlist.h>
class KviNewNick;
class KviMdiChild;

//internal struct
typedef struct KviGlobalUserListEntryTag{
	KviNewNick *lpNick;
	int nRefs;
	char firstCharUpcase;
} KviGlobalUserListEntry;

class KviGlobalUserList{
public:
	KviGlobalUserList();
	~KviGlobalUserList();
private:
	QList<KviGlobalUserListEntry> *m_lpGlobalUserList;
public:
	KviNewNick *getNick(const char *szNick);
	void clear();
	KviNewNick * addNick(KviNewNick &nk);
	KviNewNick * changeNickname(const char *szOldNick,const char *szNewNick);
	void removeNick(KviNewNick &nk);
	void removeRef(KviNewNick *lpNick);
//	KviNewNick * updateNick(KviNewNick &nk);
	KviNewNick * updateUser(KviNewNick &nk);
	void dump(KviMdiChild *lpC);
private:
	KviGlobalUserListEntry * getNickEntry(const char *szNick);
	void inSort(KviGlobalUserListEntry *lpE);
};

#endif //_KVI_UGLOBAL_H_INCLUDED_
