// $Id: kvi_types.h,v 1.3 1998/09/25 15:58:40 pragma Exp $

#ifndef _KVI_TYPES_H_
#define _KVI_TYPES_H_

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <qstring.h>
#include <qlist.h>

class KviUserParser;
class KviMdiChild;
class KviNewNick;

typedef struct kviServerEntryTag{
	QString szAddress;
	QString szIp;
	QString szPassword;
	unsigned short int iPort;
	QString szDescription;
}KviServerEntry;

typedef struct kviIrcNetworkEntryTag{
	QString szName;
	QList<KviServerEntry> *serverList;
}KviIrcNetwork;

typedef struct kviProxyEntryTag{
	QString szAddress;
	unsigned short int iPort;
	QString szIp;
	QString szUsername;
	QString szPassword;
}KviProxyEntry;

typedef struct kviListBoxEntryTag{
	KviNewNick *lpNick;
	bool     bOp;
	bool     bVoice;
	bool     bSelected;
}KviListBoxEntry;

typedef struct kviEventTag{
	QString szName;
	QString szBuffer;
	bool    bEnabled;
} KviEventStruct;

typedef struct kviUserStructTag{
	QString szNick;
	QString szMask;
	QString szActionOnJoin;
	QString szActionOnNotify;
	QString szActionOnCtcpCommand;
	QString szNotes;
	bool bNotify;
	bool bIgnore;
	bool bEnableActionOnCtcpCommand;
	bool bEnableActionOnJoin;
	bool bEnableActionOnNotify;
} KviUserStruct;

typedef struct KviBanEntryTag{
	QString szBanMask;
	QString szBanSetBy;
} KviBanEntry;

typedef struct kviIsonTag{
	QString szNick;
	bool isOn;
	KviUserStruct *lpUserStruct;
} KviIsonStruct;

typedef struct kviHostDescriptionTag{
	QString szName;
	QString szAlias1;
	QString szAlias2;
	QString szIp;
	struct in_addr iAddress;
	unsigned short int iPort;
} KviHostDescription;

typedef struct translateTabTag{
	int sysError;
	int kviError;
} twoErr;

typedef struct paramStringTag{
	QString param[10];
	QString szReturn;
} KviAliasParams;

typedef int (KviUserParser::*parseProc) (KviMdiChild *,const char **,KviAliasParams *);

typedef struct parseCmdTabTag{
	const char *szName;
	int lenName;
	parseProc proc;
} parseCmdTable;

typedef struct variableTag{
	QString szName;
	QString szValue;
} KviVariable;

typedef struct kviAliasTag{
	QString szName;
	QString szBuffer;
} KviAliasStruct;

#endif

