//
//   File : kvi_taskbar.cpp (/usr/cvs/kvirc/kvirc/kvi_taskbar.cpp)
//   Last modified : Sun Nov 22 1998 19:56:58 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviNewTaskBar"
//#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_taskbar.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_mdi.h"
#include "kvi_frame.h"


#include <X11/Xlib.h>

#include <qtooltip.h>
#include <qbuttongroup.h>
#include <qcursor.h>
#include <qrect.h>

//============ KviNewTaskBar ============//

KviNewTaskBar::KviNewTaskBar(KviFrame *lpFrame,KviMdiManager *lpMdi,const char *name)
:KToolBar(lpFrame,name)
{
	_debug_entertrace("KviNewTaskBar");
	m_lpFrm=lpFrame;
	m_lpMdi=lpMdi;
	setFullWidth(true);

	m_lpBtnList = new QList<KviNewTaskBarButton>;
	m_lpBtnList->setAutoDelete(true);
	m_bCanMove=false;
	setMouseTracking(true);

	m_lpContextPopup=new QPopupMenu();
	m_lpContextPopup->insertItem(i18n("Left"),0);
	m_lpContextPopup->insertItem(i18n("Top"),1);
	m_lpContextPopup->insertItem(i18n("Right"),2);
	m_lpContextPopup->insertItem(i18n("Bottom"),3);
	m_lpContextPopup->insertSeparator();
	m_lpContextPopup->insertItem(i18n("Hide"),4);
	connect(m_lpContextPopup,SIGNAL(activated(int)),this,SLOT(contextPopupActivated(int)));
	_debug_leavetrace("KviNewTaskBar");
}

//============ ~KviNewTaskBar ============//

KviNewTaskBar::~KviNewTaskBar()
{
	_debug_entertrace("~KviNewTaskBar");
	while(m_lpBtnList->isEmpty())m_lpBtnList->removeLast();
	delete m_lpBtnList;
	delete m_lpContextPopup;
	_debug_leavetrace("~KviNewTaskBar");
}

//============ contextPopupActivated ============//

void KviNewTaskBar::contextPopupActivated(int id)
{
	_debug_entertrace("contextPopupActivated");
	switch(id){
		case 0: setBarPos(KToolBar::Left);   break;
		case 1: setBarPos(KToolBar::Top);    break;
		case 2: setBarPos(KToolBar::Right);  break;
		case 3: setBarPos(KToolBar::Bottom); break;
		case 4: m_lpFrm->toggleTaskBar();
	}
	_debug_leavetrace("contextPopupActivated");
}

//============ getButton ============//

KviNewTaskBarButton * KviNewTaskBar::getButton(int id)
{
	_debug_entertrace("getButton");
	for(KviNewTaskBarButton *b=m_lpBtnList->first();b;b=m_lpBtnList->next()){
		if(b->m_id==id)return b;
	}
	_debug_leavetrace("getButton");
	return 0;
}

//============ addButton ============//

KviNewTaskBarButton * KviNewTaskBar::addButton(int id,const char *text,QPixmap *icon,bool bProgress=false)
{
	_debug_entertrace("addButton");
	KviNewTaskBarButton *b=new KviNewTaskBarButton(text,this,icon,id,bProgress);
	b->setFocusProxy(m_lpMdi);
	b->show();
	connect(b,SIGNAL(rightClick(int)),this,SLOT(rightButtonClick(int)));
	connect(b,SIGNAL(stateChanged(int,bool)),this,SLOT(buttonStateChanged(int,bool)));
	m_lpBtnList->append(b);
	layoutButtons();
	setActiveButton(id);
	return b;
	_debug_leavetrace("addButton");
}

//============ removeButton ============//

void KviNewTaskBar::removeButton(int id)
{
	_debug_entertrace("removeButton");
	KviNewTaskBarButton *b=getButton(id);
	if(b){
		m_lpBtnList->removeRef(b); //deletes too
		layoutButtons();
	}
	_debug_leavetrace("removeButton");
}

//============ changeButtonText ============//

void KviNewTaskBar::changeButtonText(int id,const char *text)
{
	_debug_entertrace("changeButtonText");
	KviNewTaskBarButton *b=getButton(id);
	if(b)b->setText(text);
	_debug_leavetrace("changeButtonText");
}

//============ unpressAllButtons ============//

void KviNewTaskBar::unpressAllButtons()
{
	_debug_entertrace("unpressAllButtons");
	for(KviNewTaskBarButton *b=m_lpBtnList->first();b;b=m_lpBtnList->next())b->setOn(false);
	_debug_leavetrace("unpressAllButtons");
}

//============ setActiveButton ============//

void KviNewTaskBar::setActiveButton(int id)
{
	_debug_entertrace("setActiveButton");
	for(KviNewTaskBarButton *b=m_lpBtnList->first();b;b=m_lpBtnList->next())b->setOn(b->m_id==id);
	_debug_leavetrace("setActiveButton");
}

//============ rightButtonClick ============//

void KviNewTaskBar::rightButtonClick(int id)
{
	_debug_entertrace("rightButtonClick");
	emit taskBarPopupRequest(QCursor::pos(),id);
	_debug_leavetrace("rightButtonClick");
}

//============ buttonStateChanged ============//

void KviNewTaskBar::buttonStateChanged(int id,bool bIsOn)
{
	_debug_entertrace("buttonStateChanged");
	if(bIsOn)setActiveButton(id); //will release other buttons
	emit itemActivated(id,bIsOn);
	_debug_leavetrace("buttonStateChanged");
}

//============ resizeEvent ============//

void KviNewTaskBar::resizeEvent(QResizeEvent *)
{
	_debug_entertrace("resizeEvent");
	layoutButtons();
	_debug_leavetrace("resizeEvent");
}

//============ highlightButton ============//

void KviNewTaskBar::highlightButton(int id)
{
	_debug_entertrace("highlightButton");
	KviNewTaskBarButton *b=getButton(id);
	if(b)b->highlight();
	_debug_leavetrace("highlightButton");
}

//============ setButtonProgress ============//

void KviNewTaskBar::setButtonProgress(int id,int progress)
{
	_debug_entertrace("setButtonProgress");
	KviNewTaskBarButton *b=getButton(id);
	if(b){
		b->setProgress(progress);
	}
	_debug_leavetrace("setButtonProgress");
}

//============ focusInEvent ============//

void KviNewTaskBar::focusInEvent(QFocusEvent *)
{
	_debug_entertrace("focusInEvent");
	m_lpMdi->setFocus();
	_debug_leavetrace("focusInEvent");
}

//============ layoutButtons ============//

void KviNewTaskBar::layoutButtons()
{
	_debug_entertrace("layoutButtons");
	uint btnCnt=m_lpBtnList->count();
	if(!btnCnt)return;
	QFontMetrics fm=(m_lpBtnList->isEmpty() ? fontMetrics() : m_lpBtnList->first()->fontMetrics());
	int btnHeight=fm.lineSpacing()+10;
	if(btnHeight<20)btnHeight=20;
	if((barPos() == KToolBar::Bottom)||(barPos() == KToolBar::Top)||(barPos() == KToolBar::Floating)){
		btnHeight++;
		int curWidth=width()-(2*KVI_TASKBAR_SIDE_BORDER);
		if(curWidth<0)curWidth=0;
		setMinimumHeight(btnHeight+(2*KVI_TASKBAR_TOP_BORDER));
		if(barPos() == KToolBar::Floating)setMinimumWidth((KVI_TASKBAR_VERTICAL_WIDTH*btnCnt)+(2*KVI_TASKBAR_SIDE_BORDER));
//		m_lpButtonGroup->setGeometry(KVI_TASKBAR_SIDE_BORDER,KVI_TASKBAR_TOP_BORDER,curWidth,btnHeight);
		KviNewTaskBarButton *lpB=0;
		uint aCnt=0;
		int btnWidth=(curWidth)/btnCnt;
		int left=KVI_TASKBAR_SIDE_BORDER;
		for(lpB=m_lpBtnList->first();lpB;lpB=m_lpBtnList->next()){
			if((aCnt+1)==btnCnt)lpB->setGeometry(left,KVI_TASKBAR_TOP_BORDER,curWidth-(aCnt*btnWidth),btnHeight);
			else lpB->setGeometry(left,KVI_TASKBAR_TOP_BORDER,btnWidth,btnHeight);
			aCnt++;
			left+=btnWidth;
		}
	} else {
		int curWidth=KVI_TASKBAR_VERTICAL_WIDTH-(2*KVI_TASKBAR_TOP_BORDER);
		int minHeight=(btnHeight*btnCnt)+(2*KVI_TASKBAR_SIDE_BORDER)+5;
		if(minHeight > m_lpMdi->height())minHeight=m_lpMdi->height()-2;
		resize(KVI_TASKBAR_VERTICAL_WIDTH,minHeight);
//		m_lpButtonGroup->setGeometry(KVI_TASKBAR_TOP_BORDER,KVI_TASKBAR_SIDE_BORDER,curWidth,btnHeight*btnCnt);
		KviNewTaskBarButton *lpB=0;
		uint aCnt=0;
		int top=KVI_TASKBAR_SIDE_BORDER;	
		for(lpB=m_lpBtnList->first();lpB;lpB=m_lpBtnList->next()){
			lpB->setGeometry(KVI_TASKBAR_TOP_BORDER,top,curWidth,btnHeight);
			aCnt++;
			top+=btnHeight;	
		}
	}
	_debug_leavetrace("layoutButtons");
}

//============ mousePressEvent ============//

void KviNewTaskBar::mousePressEvent(QMouseEvent *e)
{
	_debug_entertrace("mousePressEvent");
	if(e->button() == LeftButton){
		m_bCanMove=true;
		_macro_kviApplication->setOverrideCursor(sizeAllCursor);
	} else if(e->button() == RightButton)m_lpContextPopup->popup(mapToGlobal(e->pos()));
	_debug_leavetrace("mousePressEvent");
}

//============ mouseReleaseEvent ============//

void KviNewTaskBar::mouseReleaseEvent(QMouseEvent *)
{
	_debug_entertrace("mouseReleaseEvent");
	if(m_bCanMove){
		m_bCanMove=false;
		_macro_kviApplication->restoreOverrideCursor();
	}
	_debug_leavetrace("mouseReleaseEvent");
}

//============ mouseMoveEvent ============//

void KviNewTaskBar::mouseMoveEvent(QMouseEvent *)
{
	_debug_entertrace("mouseMoveEvent");
	if(m_bCanMove){
		//force update rects
		m_lpFrm->toggleTaskBar();
		//need a complete resize/repaint of the view before....aaaaargh!
		_macro_kviApplication->sendPostedEvents(this,Event_Resize);
		_macro_kviApplication->sendPostedEvents(this,Event_Paint);
		_macro_kviApplication->sendPostedEvents(m_lpMdi,Event_Resize);
		_macro_kviApplication->sendPostedEvents(m_lpMdi,Event_Paint);
		_macro_kviApplication->syncX();
		_macro_kviApplication->processEvents(); //enough???????????? not...sometimes it is not resized!
		//aaaaaaaaaaargh!
		//Calculate the button height
		QFontMetrics fm=(m_lpBtnList->isEmpty() ? fontMetrics() : m_lpBtnList->first()->fontMetrics());
		int minHeight=fm.lineSpacing()+10;
		if(minHeight<20)minHeight=20;
		minHeight+=(2*KVI_TASKBAR_TOP_BORDER);

		//the four allowed rects
		QRect leftRect(0,0,KVI_TASKBAR_VERTICAL_WIDTH,m_lpMdi->height());
		QRect topRect(0,0,m_lpMdi->width(),minHeight);
		QRect rightRect(m_lpMdi->width()-KVI_TASKBAR_VERTICAL_WIDTH,0,KVI_TASKBAR_VERTICAL_WIDTH,m_lpMdi->height());
		QRect bottomRect(0,m_lpMdi->height()-minHeight,m_lpMdi->width(),minHeight);

		QPoint oldMousePos = m_lpMdi->mapFromGlobal(QCursor::pos());
		QRect curRect=bottomRect;
		QRect oldRect=bottomRect;
		//calculate the current rect
		switch(barPos()){
			case KToolBar::Top:    curRect=topRect; break;
			case KToolBar::Bottom: curRect=bottomRect; break;
			case KToolBar::Left:   curRect=leftRect; break;
			case KToolBar::Right:  curRect=rightRect; break;
			case KToolBar::Flat:     break; //avoid warning
			case KToolBar::Floating: break;
		}
		XGrabServer(qt_xdisplay());
		//confine into the mdi manager
		XGrabPointer(qt_xdisplay(),m_lpMdi->winId(),true,
				ButtonPressMask|ButtonReleaseMask,GrabModeAsync,GrabModeAsync,
				m_lpMdi->winId(),None,CurrentTime);

		m_lpMdi->drawDragRectangle(curRect,1);
		XEvent ev;
		Window dummyWin1, dummyWin2;
		int dummy1, dummy2;
		unsigned int state;
		int mouseNewX;
		int mouseNewY;
		bool bContinue=true;
		while (bContinue && (!XCheckMaskEvent(qt_xdisplay(),(ButtonPressMask|ButtonReleaseMask),&ev))){
			XQueryPointer(qt_xdisplay(),qt_xrootwin(),&dummyWin1,&dummyWin2,&mouseNewX,&mouseNewY,&dummy1,&dummy2,&state);
			//check that the button is still pressed....(hhhm....I missed something ?)
			bContinue = state & Button1Mask;
			QPoint mousePos = m_lpMdi->mapFromGlobal(QPoint(mouseNewX, mouseNewY));

			if (oldMousePos != mousePos){
				oldMousePos = mousePos;
				//calculate the current rect
				oldRect=curRect;
				if(oldMousePos.y()<=minHeight)curRect=topRect;
				else {
					if(oldMousePos.y()>=(m_lpMdi->height()-minHeight))curRect=bottomRect;
					else {
						if(oldMousePos.x()<=KVI_TASKBAR_VERTICAL_WIDTH)curRect=leftRect;
						else {
							if(oldMousePos.x()>=(m_lpMdi->width()-KVI_TASKBAR_VERTICAL_WIDTH))curRect=rightRect;
						}
					}
				}
				if(curRect != oldRect){
					m_lpMdi->drawDragRectangle(oldRect,1);
					m_lpMdi->drawDragRectangle(curRect,1);
				}
			}
		}
		m_lpMdi->drawDragRectangle(curRect,1);

		XUngrabPointer(qt_xdisplay(),CurrentTime);
		XUngrabServer(qt_xdisplay());

		if(curRect==topRect)setBarPos(KToolBar::Top);
		else {
			if(curRect==leftRect)setBarPos(KToolBar::Left);
			else {
				if(curRect==rightRect)setBarPos(KToolBar::Right);
				else setBarPos(KToolBar::Bottom);
			}
		}
		//force update rects
		m_lpFrm->toggleTaskBar();
		m_bCanMove=false;
		_macro_kviApplication->restoreOverrideCursor();
		//Yeah!
	}
	_debug_leavetrace("mouseMoveEvent");
}

#include "m_kvi_taskbar.moc"

//
// $Log: kvi_taskbar.cpp,v $
//
// Revision 1.6  Thu Nov 26 1998 20:38:36  pragma
// OK..finally , it could be a good idea to have a BASE
// toolbar class that implements moving & docking only.
// And then KToolBar derived from that.
// DockSite concept?....
// OK....it was only an idea :)
//
// Revision 1.5  Sun Nov 22 1998 19:57:15  pragma
// Rewritten all the class to fix the QPushButton
// signal confusion...Now seems to start working.
//
// Revision 1.4  Sat Nov 21 1998 19:04:09  pragma
// Enabled moving...Floating is not supported so
// when trying to float we just setBarPos(Top);
// ....Damn! it won't work!!!!!!!!!!!!!!!!!!!!!
// KToolBoxMgr will float anyway...
// Suggestion: Why don't add a 'hot-spot only' feature to KToolBoxManager?
//
// Revision 1.3  1998/09/20 20:24:05  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.2  1998/09/15 13:19:38  pragma
// Taskbar buttons progress view fix.
//
