//   $Id: kvi_sysbtn.cpp,v 1.2 1998/09/20 20:24:04 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#define _KVI_DEBUG_CLASS_NAME_ "KviSysWinButton"

#include "kvi_sysbtn.h"
#include "kvi_child.h"

#include <qpainter.h>
#include <qdrawutil.h>

////////////////////
// WARNING :
// You MUST call set focus owner
// with a windows child to work

KviSysWinButton::KviSysWinButton(KviMdiChild *parent,const char *name) : QPushButton(parent,name)
{
	setToggleButton(true);
	setFocusPolicy(QWidget::NoFocus);
}

KviSysWinButton::~KviSysWinButton()
{
	
}

void KviSysWinButton::drawButton(QPainter *p)
{
	if(isDown()){
		qDrawShadePanel(p,0,0,width(),height(),colorGroup(),true,1,0);
		p->translate(-1.0,-1.0);
		drawButtonLabel(p);
	} else if(isOn()){
		qDrawShadePanel(p,0,0,width(),height(),colorGroup(),false,1,0);
		p->translate(-1.0,-1.0);
		drawButtonLabel(p);
	} else {
		qDrawPlainRect(p,0,0,width(),height(),backgroundColor(),1,0);
		drawButtonLabel(p);
	}
}

void KviSysWinButton::enterEvent(QEvent *)
{
	setOn(true);
}

void KviSysWinButton::leaveEvent(QEvent *)
{
	setOn(false);
}

#include "m_kvi_sysbtn.moc"
