//   $Id: kvi_status.cpp,v 1.2 1998/09/20 20:24:00 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CLASS_NAME_ "KviStatusWnd"

#include "kvi_defs.h"
#include "kvi_macros.h"
#include "kvi_status.h"
#include "kvi_input.h"
#include "kvi_view.h"
#include "kvi_listbox.h"
#include "kvi_app.h"
#include "kvi_int.h"
#include "kvi_frame.h"
#include "kvi_opt.h"
#include "kvi_debug.h"
#include "kvi_mdi.h"
#include "kvi_support.h"

#include <kconfig.h>

#include <qtooltip.h>

#include <stdarg.h>

KviStatusWnd::KviStatusWnd(KviMdiManager *parent,KviFrame *frame)
				:KviMdiChild(parent,frame,KVI_STATUS_WND_NAME,0,KVI_WND_TYPE_STATUS)
{
	KConfig *lpCfg=_macro_kviConfig;
	lpCfg->setGroup("KviStatusWndOptions");
	int percent=lpCfg->readNumEntry("PannerPercent",75);

	m_lpInput      = new KviInput(this,0,KVI_WND_TYPE_STATUS,KVI_STATUS_WND_NAME,frame,"KviInputClass");
	m_lpPanner     = new KNewPanner(this,"KviStatusPanner",KNewPanner::Vertical,KNewPanner::Percent,percent);
	m_lpOutput     = new KviView(m_lpPanner,frame,"KviViewClass");
	m_lpNotifyList = new KviListBox(m_lpPanner,this,frame,"KviNotifyList");

	m_lpPanner->activate(m_lpOutput,m_lpNotifyList);
	QToolTip::add(m_lpNotifyList,"Notify list");
	
	m_lpOutput->m_lpStatParent=this;

	setFocusOwner(m_lpInput);

	doOutput(KVI_OUT_KVIRC,"     //     // //      //");
	doOutput(KVI_OUT_KVIRC,"    //   //    //    //   //////  /// ////  ///////");
	doOutput(KVI_OUT_KVIRC,"   /////       //  //      //     ////    //");
	doOutput(KVI_OUT_KVIRC,"  //   //      ////       //     //      //");
	doOutput(KVI_OUT_KVIRC," //    //      //      //////  ////      ////////");
	doOutput(KVI_OUT_KVIRC," ");
	doOutput(KVI_OUT_KVIRC,KVI_VERSION);
	doOutput(KVI_OUT_KVIRC,"Home site : http://www.kvirc.org");

	enableClose(false);

	applyOptions();
}

KviStatusWnd::~KviStatusWnd()
{
	KConfig *lpCfg=_macro_kviConfig;
	lpCfg->setGroup("KviStatusWndOptions");
	lpCfg->writeEntry("PannerPercent",m_lpPanner->separatorPos());

	delete m_lpInput;
	delete m_lpOutput;
	delete m_lpNotifyList;
	delete m_lpPanner;
}

void KviStatusWnd::applyOptions(){
	m_lpInput->enableColorBox(m_lpFrm->m_lpOpt->bShowColorBox);
	m_lpInput->setDefaultBackgroundColor(m_lpInt->clr_bk_input);
	m_lpInput->setDefaultForegroundColor(m_lpInt->clr_fr_input);
	m_lpInput->setMarkBackgroundColor(m_lpInt->clr_bk_sel_input);
	m_lpInput->setMarkForegroundColor(m_lpInt->clr_fr_sel_input);
	m_lpInput->setCursorColor(m_lpInt->clr_cursor_input);
	m_lpInput->setFont(m_lpInt->fnt_input);
	m_lpOutput->m_bTimestamp=m_lpFrm->m_lpOpt->bTimestamp;
	m_lpOutput->m_bShowPixmaps=m_lpFrm->m_lpOpt->bShowPixmaps;
	m_lpNotifyList->setFont(m_lpInt->fnt_listbox);
	if(!m_lpInt->pix_bk_input.isNull())m_lpInput->setBackgroundPixmap(m_lpInt->pix_bk_input);
	m_lpOutput->setFont(m_lpInt->fnt_output);
	const QSize sz=size();
	QResizeEvent e(sz,sz);
	resizeEvent(&e);
}

void KviStatusWnd::resizeEvent(QResizeEvent *){
	_debug_entertrace("resizeEvent");
	updateRects();
	QRect rct=viewSizeHint();
	QFontMetrics fnt=m_lpInput->fontMetrics();
	int input_hght=fnt.lineSpacing()+8;
	m_lpInput->setGeometry(rct.left(),rct.top()+rct.height()-input_hght,rct.width(),input_hght);
	m_lpPanner->setGeometry(rct.left(),rct.top(),rct.width(),rct.height()-(input_hght+KVI_MDI_VIEW_SEP));
	_debug_leavetrace("resizeEvent");
}
void KviStatusWnd::doFmtOutput(int nType,const char *szFmt,...){
	char szText[600]; //It should be big enough... I hope...
	va_list list;
	va_start(list,szFmt);
	if(vsnprintf(szText,600,szFmt,list)==-1)debug("WARNING : Output string truncated"); // Fritz : vsnprintf
	va_end(list);
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,(const char *) &szText);
}
void KviStatusWnd::doOutput(int nType,const char *szText){
	m_lpMdi->highlightWindow(m_iId);
	m_lpOutput->appendText(nType,szText);
}
#include "m_kvi_status.moc"
