//
//   File : kvi_sparser.h (/usr/cvs/kvirc/kvirc/kvi_sparser.h)
//   Last modified : Fri Nov 27 1998 21:28:54 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//


#ifndef _KVI_SPARSER_H_INCLUDED_
#define _KVI_SPARSER_H_INCLUDED_

#include <qstring.h>

class KviStatusWnd;
class KviChanWnd;
class KviQueryWnd;
class KviServerParser;
class KviIrcSocket;
class KviUserParser;
class KviCTCP;
class KviNewNick;
class KviFrame;
class KviMdiManager;
class KviMdiChild;
class KviEventManager;
class KviUser;
class KviOptions;

typedef void (KviServerParser::*handleProc) (QString &,QString &);

typedef struct handleCmdTabTag{
	const char *szName;
	handleProc proc;
} handleCmdTable;

class KviServerParser{
public:
	KviServerParser(KviFrame *lpFrame);
	~KviServerParser();
protected:
	static handleCmdTable cmdTab[];
public:
	KviFrame		*m_lpFrm;
	KviMdiManager	*m_lpMdi;
	KviStatusWnd 	*m_lpCons;
	KviIrcSocket 	*m_lpSock;
	KviUser			*m_lpUsr;
	KviOptions		*m_lpOpt;
	KviCTCP			*m_lpCTCP;
	KviEventManager *m_lpEventManager;
	KviUserParser   *m_lpUserParser;
	int              m_iFileRequests;
public:
	KviMdiChild * topWin();
	KviMdiChild * findWin(const char *szName);
	KviChanWnd * getChanWnd(const char *szName);
	KviQueryWnd * getQueryWnd(const char *szName);
	void parseMessage(QString &szMessage);

	void activate(KviIrcSocket *lpSock);

	const char * skipWord(QString &szString);
	const char * skipUpToTrailing(QString &szString);

	void setStatus(const char *szFmt,const char *szData);

	bool isMe(QString &szNick);

	void parseNumericError(QString &szPrefix,int nCommand,QString &szParams);
	void parseNumericReply(QString &szPrefix,int nCommand,QString &szParams);

	void parseLiteral(QString &szPrefix,QString &szCommand,QString &szParams);

	void handleNickError(int nCommand,QString &szParams);
	void handleNameReply(int nCommand,QString &szParams);
	void handleTopicReply(int nCommand,QString &szParams);
	void handleChanList(int nCommand,QString &szParams);
	void handleModeReply(QString &szPrefix,QString &szParams);
	void handleBanList(int nCommand,QString &szParams);
	void handleCreationTime(QString &szParams);

	void handlePing(QString &szPrefix,QString &szParams);
	void handleJoin(QString &szPrefix,QString &szParams);
	void handlePart(QString &szPrefix,QString &szParams);
	void handleTopic(QString &szPrefix,QString &szParams);
	void handleKick(QString &szPrefix,QString &szParams);
	void handleNick(QString &szPrefix,QString &szParams);
	void handlePrivmsg(QString &szPrefix,QString &szParams);
	void handleNotice(QString &szPrefix,QString &szParams);
	void handleMode(QString &szPrefix,QString &szParams);
	void handleQuit(QString &szPrefix,QString &szParams);
	void handleInvite(QString &szPrefix,QString &szParams);
	void handleIsOn(QString &szParams);
	void handleChanUrl(QString &szParams);
	void handleError(QString &szPrefix,QString &szParams);
	void handleUserHost(QString &szParams);
	void handleWhois(QString &szPrefix,int nCommand,QString &szParams);
	void handleChanUserMode(KviChanWnd *lpWnd,KviNewNick &source,char mode,bool bAdd,QString &szParam);
	void handleLinks(int nCommand,QString &szParams);
};

#endif //_KVI_SPARSER_H_INCLUDED_
