//   $Id: kvi_setup.cpp,v 1.7 1998/09/20 20:23:44 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CLASS_NAME_ "KviSetup"

#include "kvi_macros.h"
#include "kvi_setup.h"
#include "kvi_debug.h"
#include "kvi_app.h"

#include <kfm.h>
#include <kmsgbox.h>
#include <kiconloader.h>
#include <kprocess.h>

#include <qfiledialog.h>

//============ KviSetup ============//

KviSetup::KviSetup()
{
	_debug_entertrace("KviSetup");
	_debug_leavetrace("KviSetup");
}

//============ ~KviSetup ============//

KviSetup::~KviSetup()
{
	_debug_entertrace("~KviSetup");
	_debug_leavetrace("~KviSetup");
}

//============ insertWallpapersDirectory ============//

void KviSetup::insertWallpapersDirectory()
{
	_debug_entertrace("insertWallpapersDirectory");
	QString szDir=_macro_kviApplication->kde_wallpaperdir().data();
	if(directoryExists(szDir.data())){
		_macro_kviIconLoader->insertDirectory(0,szDir);
	}
	_debug_leavetrace("insertWallpapersDirectory");
}

//============ setup ============//

void KviSetup::setup()
{
	_debug_entertrace("setup");
	//check if $KDE/share/apps/kvirc exists.
	QString szDir=getGlobalDataDirectory(0);
	if(!directoryExists(szDir.data())){
		QString szWarn=i18n("The directory $KDEDIR/share/apps/kvirc\n(");
		szWarn+=szDir.data();
		szWarn+=i18n(") does not exists.\n");
		szWarn+=i18n("Make install was not executed or failed for some reason.\n"
		             "Please read the INSTALL file shipped with the KVirc source.");
		KMsgBox::message(0,i18n("WARNING"),szWarn.data());
		return;
	}
	//check if we already defined a home dir for kvirc
	QString szKVircHomeDir=_macro_getKVircHomeDirectory(0);
	if(szKVircHomeDir.isEmpty())executeSetup(false);
	//setup our icon loader
	//need to add the wallpaper directory...it is always full of images :)
	insertWallpapersDirectory();

	szDir=_macro_getKVircHomeDirectory("Scripts/Images");
	_macro_kviIconLoader->insertDirectory(0,szDir);
	szDir=_macro_getKVircHomeDirectory("Images");
	_macro_kviIconLoader->insertDirectory(0,szDir);
	//check for $HOME/kvirc.
	szDir=_macro_getKVircHomeDirectory(0);
	if(!directoryExists(szDir.data()))executeSetup(false);
	else {
		bool bNeedSetup=true;
		szDir=_macro_getKVircHomeDirectory("Audio");
		bNeedSetup=(!directoryExists(szDir.data()));
		szDir=_macro_getKVircHomeDirectory("Ascii");
		bNeedSetup=(!directoryExists(szDir.data()));
		szDir=_macro_getKVircHomeDirectory("Incoming");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Config");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Logs");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Images");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Scripts");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Scripts/Audio");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Scripts/Images");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Scripts/Misc");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Scripts/Ascii");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Translation");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		szDir=_macro_getKVircHomeDirectory("Misc");
		bNeedSetup=((!directoryExists(szDir.data())) || bNeedSetup);
		if(bNeedSetup)executeSetup(true);
	}
	_debug_leavetrace("setup");
}

//============ executeSetup ============//

void KviSetup::executeSetup(bool bRepeat)
{
	_debug_entertrace("executeSetup");
	QString szMsg;
	if(!bRepeat){
		szMsg=i18n("Welcome to the KVirc auto-setup.\n\n"
		           "A program home directory needs to be created.\n"
				   "KVirc will store there its configuration files and\n"
				   "the downloaded data.");
	} else {
		szMsg=i18n("KVirc detected a misconfiguration in its home directory.\n"
				   "The setup needs to be repeated to rebuild the correct dependancies.\n"
				   "You may also choose a different directory as the home dir now,\n"
				   "but you will have to move there manually your current settings\n"
		           "if you want to keep it.");
	}
	KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());

	szMsg=i18n("Let's go!\n"
			   "You will have the possibility to choose an existing directory now.\n"
			   "A 'kvirc' subdir will be created inside that directory.\n"
			   "This directory will contain config files , audio files ,\n"
			   "unpacked scripts and downloaded data.\n"
			   "Remember that this setting can be changed only by deleting\n"
			   "(or renaming) that directory.\n"
			   "Please make sure that you have the full write/read access there.\n"
			   "The best place to make it is somewhere in your HOME directory tree.");

	KMsgBox::message(0,i18n("KVirc home directory"),szMsg.data());

	QString szDef=_macro_kviApplication->localkdedir();
	if(szDef.isEmpty()){
		szDef=QString(QDir::homeDirPath());
	} else szDef+="/share/apps";

	QString szKVircHomeDir=QFileDialog::getExistingDirectory(szDef.data(),0);

	if(szKVircHomeDir.isEmpty()){
		//use $HOME/kvirc...just because that is the only 
		//one that the user MUST have the r/w access.
		//other dirs may create unexpected problems...
		szMsg=i18n("You have selected no directory.\n"
		           "A default base directory will be used : $HOME");
		KMsgBox::message(0,i18n("No directory selected"),szMsg.data());
		szKVircHomeDir=QString(QDir::homeDirPath());
	}

	szKVircHomeDir+='/';
	szKVircHomeDir+="kvirc";

	_macro_kviApplication->szKVircHomeDir=szKVircHomeDir.copy();

	QString szDirsCreated;
	szDirsCreated+=createHomeDirIfNotExists(0);
	szDirsCreated+=createHomeDirIfNotExists("Audio");
	szDirsCreated+=createHomeDirIfNotExists("Ascii");
	szDirsCreated+=createHomeDirIfNotExists("Incoming");
	szDirsCreated+=createHomeDirIfNotExists("Config");
	szDirsCreated+=createHomeDirIfNotExists("Logs");
	szDirsCreated+=createHomeDirIfNotExists("Images");
	szDirsCreated+=createHomeDirIfNotExists("Scripts");
	szDirsCreated+=createHomeDirIfNotExists("Scripts/Audio");
	szDirsCreated+=createHomeDirIfNotExists("Scripts/Misc");
	szDirsCreated+=createHomeDirIfNotExists("Scripts/Images");
	szDirsCreated+=createHomeDirIfNotExists("Scripts/Ascii");
	szDirsCreated+=createHomeDirIfNotExists("Translation");
	szDirsCreated+=createHomeDirIfNotExists("Misc");
	if(!szDirsCreated.isEmpty()){
		szDirsCreated.prepend(i18n("The following directories were created :\n"));
		KMsgBox::message(0,i18n("KVirc auto-setup"),szDirsCreated.data());
	}
	szDirsCreated="";
	szDirsCreated+=copyAllFrom(0);
	szDirsCreated+=copyAllFrom("Audio");
	szDirsCreated+=copyAllFrom("Ascii");
	szDirsCreated+=copyAllFrom("Incoming");
	szDirsCreated+=copyAllFrom("Config");
	szDirsCreated+=copyAllFrom("Logs");
	szDirsCreated+=copyAllFrom("Images");
	szDirsCreated+=copyAllFrom("Scripts");
	szDirsCreated+=copyAllFrom("Scripts/Audio");
	szDirsCreated+=copyAllFrom("Scripts/Images");
	szDirsCreated+=copyAllFrom("Scripts/Misc");
	szDirsCreated+=copyAllFrom("Scripts/Ascii");
	szDirsCreated+=copyAllFrom("Translation");
	szDirsCreated+=copyAllFrom("Misc");
	if(!szDirsCreated.isEmpty()){
		szDirsCreated.prepend(i18n("The following files were created :\n"));
		if(szDirsCreated.length()>512){
			szDirsCreated.truncate(512);
			szDirsCreated.append(i18n("...\n...\n...more files"));
		}
		KMsgBox::message(0,i18n("KVirc auto-setup"),szDirsCreated.data());
	}
	szMsg=i18n("KVirc can make a link on your Desktop\n"
			   "to the newly created application directory.\n"
			   "This will be useful to find that directory quickly.\n"
			   "It may not work you re running kvirc from 'su username' or\n"
			   "you're not running kfm at all.\n"
			   "In that case say 'No'\n"
			   "Proceed?\n");
	QString szHome(QDir::homeDirPath());
	QString szKVircHome(_macro_getKVircHomeDirectory(0));
	szHome+="/Desktop/kvirc_home";
	makeLinkIfRequested(szMsg,szKVircHome.data(),szHome.data(),true);
	szMsg=i18n("KVirc can make a link in your $HOME directory\n"
				"to the newly created application directory.\n"
				"If you have selected your $HOME directory as the application\n"
				"base directory, this will not be useful for you.\n"
				"In that case say 'No'\n"
				"Proceed?\n");
	szHome=QString(QDir::homeDirPath());
	szHome+="/kvirc_home";
	makeLinkIfRequested(szMsg,szKVircHome.data(),szHome.data(),false);
	KMsgBox::message(0,i18n("KVirc auto-setup"),i18n("Setup terminated."));
	_debug_leavetrace("executeSetup");
}

//============ makeLinkIfRequested ============//

void KviSetup::makeLinkIfRequested(QString &szMsg,const char *szFileToLink,const char *szLinkTarget,bool bRefreshDesktop)
{
	_debug_entertrace("makeLinkIfRequested");
	if(KMsgBox::yesNo(0,i18n("KVirc auto-setup (link)"),szMsg)==1){
		KShellProcess *lpProc=new KShellProcess();
        //run ln -s KVIRCDIR $HOME/kvirc
		(*lpProc) << "ln" << "-s" << "-n";
		(*lpProc) << szFileToLink;
		(*lpProc) << szLinkTarget;
		lpProc->start(KProcess::DontCare,KProcess::NoCommunication);
		delete lpProc;
		if(bRefreshDesktop){
			//is this safe???
			KFM *myKFM=new KFM();
			if(myKFM->isKFMRunning())myKFM->refreshDesktop();
			delete myKFM;
		}
	}
	_debug_leavetrace("makeLinkIfRequested");
}

//============ copyAllFrom ============//

QString KviSetup::copyAllFrom(const char *subdir)
{
	_debug_entertrace("copyAllFrom");
	QString szFilesCopied="";
	QString szDir=getGlobalDataDirectory(subdir);
	QDir theDir(szDir.data());
	const QFileInfoList * lpList=theDir.entryInfoList();
	if(!lpList)return szFilesCopied;
	QFileInfoListIterator it(*lpList);
	for( ; it.current() ; ++it){
		QFileInfo *lpInfo=it.current();
		if(lpInfo->isFile()){
			QString szFileName=lpInfo->absFilePath();
			if(!lpInfo->isReadable()){
				QString szMsg;
				szMsg.sprintf(i18n("Unable to read file %s\n"
						   "It's possible that you don't have the right permissions to do it.\n"
						   "Since this is a default configuration file, KVirc will work without it\n"
						   "But you may want to ask your system administrator to copy that file for you\n"
						   "or give you read access to that file."), szFileName.data());
				KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
			} else {
				uint fSize=lpInfo->size();
				if(fSize){
					QString szDirectory=_macro_getKVircHomeDirectory(subdir);
					szDirectory+='/';
					szDirectory+=lpInfo->fileName();
					QFile newOne(szDirectory.data());
					QFile oldOne(szFileName.data());
					if(!newOne.exists()){
						if(oldOne.exists()){
							if(newOne.open(IO_WriteOnly)){
								if(oldOne.open(IO_ReadOnly)){
									char block[4096];
									int readBlock=4096;
									while(fSize){
										if(fSize<4096)readBlock=fSize;
										fSize-=readBlock;
										if(oldOne.readBlock(block,readBlock)==readBlock){
											if(newOne.writeBlock(block,readBlock)<readBlock){
												QString szMsg;
												szMsg.sprintf(i18n("File I/O error while writing %s"),
													      szDirectory.data());
												KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
												fSize=0;
											}					
										} else {
											QString szMsg;
											szMsg.sprintf(i18n("File I/O error while reading %s"),
												      szFileName.data());
											KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
											fSize=0;
										}
									}
									szFilesCopied+=szDirectory;
									szFilesCopied+='\n';
									oldOne.close();
									newOne.close();
								} else {
									QString szMsg;
									szMsg.sprintf(i18n("Unable to open file %s for reading."),
										      szFileName.data());
									KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
								}			
							} else {
								QString szMsg;
								szMsg.sprintf(i18n("unable to open file %s for writing."),
									      szDirectory.data());
								KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
							}
						}
					}		
				}
			}
		}
	}
	return szFilesCopied;
	_debug_leavetrace("copyAllFrom");
}

//============ createHomeDirIfNotExists ============//

QString KviSetup::createHomeDirIfNotExists(const char *subdir)
{
	_debug_entertrace("createHomeDirIfNotExists");
	QString szHome=_macro_getKVircHomeDirectory(subdir);
	QDir theDir(szHome.data());
	if(!theDir.exists()){
		if(!theDir.mkdir(szHome.data())){
			QString szMsg;
			szMsg.sprintf(i18n("Unable to create %s directory.\n"),
				      szHome.data());
			KMsgBox::message(0,i18n("KVirc auto-setup"),szMsg.data());
		}
	} else {
		QString empty="";
		return empty;
	}
	szHome+='\n';
	return szHome;
	_debug_leavetrace("createHomeDirIfNotExists");
}

//============ getGlobalDataDirectory ============//

QString KviSetup::getGlobalDataDirectory(const char *subdir)
{
	_debug_entertrace("getGlobalDataDirectory");
	QString szDir=KApplication::kde_datadir().data();
	if(szDir.isEmpty()){
		KMsgBox::message(0,i18n("WARNING"),
				 i18n("Your KDE einviroinment is not configured correctly.\n"
				      "Unable to get the $KDEDIR/share/apps global directory."));
		szDir=KApplication::localkdedir();
		if(szDir[szDir.length()-1]!='/')szDir+='/';
		szDir+="share/apps";
	}
	if(szDir[szDir.length()-1]!='/')szDir+='/';
	szDir+="kvirc";
	if(subdir){
		szDir+='/';
		szDir+=subdir;
	}
	return szDir;
	_debug_leavetrace("getGlobalDataDirectory");
}

//============ directoryExists ============//

bool KviSetup::directoryExists(const char *directory)
{
	_debug_entertrace("directoryExists");
	QDir theDir(directory);
	return (theDir.exists() && theDir.isReadable());
	_debug_leavetrace("directoryExists");
}

//
// $Log: kvi_setup.cpp,v $
// Revision 1.7  1998/09/20 20:23:44  fritz
// reorganized includes.
// More work on srvdlg - still not finished.
//
// Revision 1.6  1998/09/17 16:14:39  pragma
// Moving to handle mp3 , au and mid files by external players.
//
// Revision 1.5  1998/09/17 02:16:13  pragma
// Another hack here...added link in home dir , and modified a couple of
// messages.
//
// Revision 1.4  1998/09/16 17:39:28  fritz
// Fix in i18n call
//
// Revision 1.3  1998/09/16 17:16:54  fritz
// Starting i18n.
//
// Revision 1.2  1998/09/16 16:13:21  pragma
// Moving to use a dynamic kvirc home directory.
// Big commit :)
//
//
