//   $Id: kvi_scrdlg.h,v 1.2 1998/09/20 20:23:35 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_SCRIPT_DIALOGS_H_INCLUDED_
#define _KVI_SCRIPT_DIALOGS_H_INCLUDED_

#include <qmultilinedit.h>
#include <qdialog.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlineedit.h>
#include <qcheckbox.h>

class KviScriptLoadDialog : public QDialog{
	Q_OBJECT
public:
	KviScriptLoadDialog(KviFrame *lpFrm,KviScriptDescription *lpS,const char *fileName);
	~KviScriptLoadDialog();
public:
	KviFrame             *m_lpFrm;
	KviScriptDescription *m_lpScr;
public:
	QString         m_szFileName;
	QLabel          *lpAuth;
	QMultiLineEdit  *lpDesc;
	QMultiLineEdit  *lpLog;
	QPushButton     *lpOk;
	QPushButton     *lpCancel;
	QPushButton     *lpHelp;
public slots:
	void acceptInstall();
	void requestHelp();
};

class KviScriptSaveDialog : public QDialog{
	Q_OBJECT
public:
	KviScriptSaveDialog(KviFrame *lpFrm);
	~KviScriptSaveDialog();
public:
	KviFrame             *m_lpFrm;
	KviScriptDescription m_ScrDes;
	QLineEdit            *lpAuth;
	QMultiLineEdit       *lpDesc;
	QCheckBox            *lpHasColorEntries;
	QCheckBox            *lpHasColorMap;
	QCheckBox            *lpHasOptions;
	QCheckBox            *lpHasEvents;
	QCheckBox            *lpHasAliases;
	QCheckBox            *lpHasPopups;
	QCheckBox            *lpHasInterface;
	QCheckBox            *lpHasAudioFiles;
	QCheckBox            *lpHasMiscFiles;
	QCheckBox            *lpHasImages;
	QCheckBox            *lpHasAsciiFiles;
	QPushButton          *lpOk;
	QPushButton          *lpHelp;
	QPushButton          *lpCancel;
public slots:
	void acceptSave();
	void requestHelp();
};
#endif //_KVI_SCRIPT_DIALOGS_H_INCLUDED_
