//   $Id: kvi_proc.h,v 1.2 1998/09/20 20:23:31 fritz Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_PROC_H_INCLUDED_
#define _KVI_PROC_H_INCLUDED_

#include <kprocess.h>

class KviFrame;
class KviStatusWnd;
class KviMdiChild;

typedef struct KviProcParamTag{
	QString szStdIn;
	QString szCmdLine;
	bool    bCanWrite;
	KProcess *lpProc;
	int     iPid;
} KviProcParams;

class KviProcessManager:public QObject{
	friend class KviUserParser;
	Q_OBJECT
public:
	KviProcessManager(KviFrame *lpFrame);
	~KviProcessManager();
protected:
	KviFrame       *m_lpFrm;
	KviStatusWnd   *m_lpCons;
	QList<KviProcParams> *m_lpProcList;
public:
	void runProcess(const char *procCmdLine);  //run only
	void execProcess(const char *procCmdLine); //run and get output
	void killProcess(int aPid);
	void writeProcess(int aPid,const char *buffer);
	void killAll();
	KviProcParams * getProcByPid(int aPid);
	KviProcParams * getProcByPtr(KProcess *proc);
protected slots:
	void slotWrote(KProcess *proc);
	void slotExited(KProcess *proc);
	void slotGotStdout(KProcess *proc,char *buffer,int buflen);
	void slotGotStderr(KProcess *proc,char *buffer,int buflen);
private:
	KviMdiChild * topWin();
};

#endif //_KVI_PROC_H_INCLUDED_
