//
//   File : kvi_opt.h (/usr/cvs/kvirc/kvirc/kvi_opt.h)
//   Last modified : Tue Dec 1 1998 02:44:39 by root@localhost.localdomain
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998-1999 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation ; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING. If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_OPTIONS_H_INCLUDED_
#define _KVI_OPTIONS_H_INCLUDED_

#include <qstring.h>
#include <qstrlist.h>

class KviOptions{
public:
	KviOptions();
	~KviOptions();
public:
	//Mesages
	QString szCaption;
	QString szQuitMsg;
	QString szPartMsg;
	QString szKickMsg;
	QString szAwayMsg;
	QString szFinger;
	QString szUserInfo;
	QString szScriptVer;
	QString szStatusMsg;
	//DCC Settings
	QStrList *lpListDccMotd;
	bool bShowMotdOnOutDcc;
	bool bShowMotdOnInDcc;
	bool bIgnoreDCCChat;
	bool bIgnoreDCCSend;
	bool bIgnoreDCCVoice;
	bool bAutoAcceptDCCSend;
	bool bAutoAcceptDCCChat;
	bool bAutoAcceptDCCVoice;
	bool bMinimizeDCCSend;
	int iDCCCHATTimeout;
	bool bAutoCloseDCCChatOnSuccess;
	int iDCCSendPacketSize; //(64-2048)
	bool bUseFastSend;
	int iFSPacketsPerSec;
	//DCC Daemon
	bool bUseDCCDaemon;
	unsigned short int iDCCDaemonPort;
	bool bDCCChatServiceAvailable;
	bool bDCCSendServiceAvailable;
	int iDCCDLoginTimeout;
	//Protections
	Q_UINT32 massDeopDeadline;
	Q_UINT32 massDeopTime;
	Q_UINT32 massOpDeadline;
	Q_UINT32 massOpTime;
	Q_UINT32 massKickDeadline;
	Q_UINT32 massKickTime;
	Q_UINT32 massBanDeadline;
	Q_UINT32 massBanTime;
	Q_UINT32 publicFloodDeadline;
	Q_UINT32 publicFloodTime;
	int iMaxCTCP;
	int iTimerCTCP;
	//Translation maps
	bool bUseTranslation;
	bool bNotTranslateDCC;
	QString szTranslationFile;
	//Local Ip for multiIp machines
	QString szLocalIp;

	QString szTextUserBuffer[10];

	//misc
	bool bAutoRejoinOnKick;
	bool bPrefixMsg; //prefix msgs with :
	bool bInverseNick;
	char chPersonalCommandPrefix;

	bool bEnableUserListUpdate;
	int iUserListUpdateTime;
	bool bCloneScanOnJoin;
	//translation and notify list
	bool bEnableNotifyList;
	int iNotifyTimer;
	bool bNotifyListInActive;

//	QStrList *lpNotifyList;
	//browser and url catching
	bool bRunBrowserOnUrl;
	bool bUseNetscape;
	bool bHighlightUrl;
	char urlHighlightForeColor;
	QString szBrowserCmdLine;
	//protections



//	int iFSPacketSize;
	//moved here from interface settings
	bool bShowColorBox;
	bool bTimestamp;
	bool bAlignText;
	bool bShowPixmaps;
	bool bPrivNoticeToActive;
	bool bCtcpRequestsToActive;

	bool bAutoJoinOnInvite;
	bool bListenToCtcpSound;
	bool bPlayDefSound; //play default.wav on CTCP Sound wav file not found
	bool bSendSoundRequest;
	bool bListenToFileRequest;
	int iMaxFileRequests;

	bool bExternalAuPlayer;
	bool bExternalMidPlayer;
	bool bExternalMp3Player;
	bool bExternalWavPlayer;
	QString szAuPlayerCmd;
	QString szMidPlayerCmd;
	QString szMp3PlayerCmd;
	QString szWavPlayerCmd;

	bool bEnableActionsOnJoin;
	bool bEnableActionsOnNotify;
	bool bEnableActionsOnCtcpCommand;
	bool bEnableIgnoreList;

	bool bAutoNickCompletion;
	bool bIdentParsingOff;

	bool bAutoLogChannels;
	bool bAutoLogQueries;
	bool bAutoLogChats;

	bool bMinimizeQuery;

	bool bBeepOnPrivmsg;
	bool bBeepOnDCCRequest;
	bool bBeepOnCTCPRequest;
public:
	void readSettings();
	void saveSettings();
//private:
//	void preventVariableDestroy(QString &szString);
};

#endif //_KVI_OPTIONS_H_INCLUDED_
