//   $Id: kvi_nick.cpp,v 1.4 1998/09/23 23:15:09 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#define _KVI_DEBUG_CHECK_RANGE_

#include "kvi_defs.h"
#include "kvi_nick.h"
#include "kvi_debug.h"

#include <qregexp.h>

#include <ctype.h>



//============ KviNewNick ============//

KviNewNick::KviNewNick()
{
	_debug_entertrace("KviNewNick");
	szNick     = KVI_STR_NULL;
	szUserName = KVI_STR_NULL;
	szAddress  = KVI_STR_NULL;
	_debug_leavetrace("KviNewNick");
}

//============ KviNewNick ============//

KviNewNick::KviNewNick(const KviNewNick &nk)
{
	_debug_entertrace("KviNewNick");
	szNick     = nk.szNick.data();
	szUserName = nk.szUserName.data();
	szAddress  = nk.szAddress.data();
	_debug_leavetrace("KviNewNick");
}

//============ KviNewNick ============//

KviNewNick::KviNewNick(const char *szMask)
{
	_debug_entertrace("KviNewNick");
	fromMask(szMask);
	_debug_leavetrace("KviNewNick");
}

//============ KviNewNick ============//

KviNewNick::KviNewNick(QString &szMask)
{
	_debug_entertrace("KviNewNick");
	fromMask(szMask.data());
	_debug_leavetrace("KviNewNick");
}


//============ ~KviNewNick ============//

KviNewNick::~KviNewNick()
{
	_debug_entertrace("~KviNewNick");
	_debug_leavetrace("~KviNewNick");
}

//============ fromMask ============//

void KviNewNick::fromMask(const char *szMask)
{
	_debug_entertrace("fromMask");
	_range_valid(szMask);
	const char *pC=szMask;
	//skip spaces and op/voice flags
	while((*pC)&&((*pC==' ')||(*pC=='@')||(*pC=='+')))pC++;
	//the string begins here
	const char *pApp=pC;
	if(*pC){
		//go to the end of the nickname
		while((*pC) && (*pC != '!'))pC++;
		if(*pC){ //Complete mask
			szNick=QString(pApp,(pC-pApp)+1);
			if(pC==pApp)szNick=KVI_STR_NULL;
			pC++;
			if(*pC){ //Nick!something
				pApp=pC;
				while((*pC) && (*pC != '@'))pC++;
				szUserName=QString(pApp,(pC-pApp)+1);
				if(pC==pApp)szUserName=KVI_STR_NULL;
				if(*pC){ //complete mask
					pC++;
					if(*pC){ //complete mask
						//pApp=pC;
						//while(*pC)pC++;
						szAddress=QString(pC);
						if(szAddress.isEmpty())szAddress=KVI_STR_NULL;
						return;
					} else { //Nick!username@
						szAddress=KVI_STR_NULL;
						return;
					}
				} else { //nick!username
					szAddress=KVI_STR_NULL;
					return;
				}
			} else { //Nick!
				szAddress=KVI_STR_NULL;
				szUserName=KVI_STR_NULL;
				return;
			}
		} else { //Only a nick
			pC=pApp;
			szNick=QString(pC);
			while((*pC) && (*pC != '.'))pC++;
			if(*pC=='.'){
				szUserName="ircd"; //irc daemon :)
				szAddress=szNick.copy();  //  irc.dal.net (ircd@irc.dal.net)
			} else {
				szUserName=KVI_STR_NULL;
				szAddress=KVI_STR_NULL;
			}
			return;			
		}
	} else { //corrupted nick mask
		szNick=KVI_STR_NULL;
		szAddress=KVI_STR_NULL;
		szUserName=KVI_STR_NULL;
	}	
	_debug_leavetrace("fromMask");
}

void KviNewNick::mask(QString &szMask,int type)
{
	_debug_entertrace("mask");
	_range_invalid(szNick.isEmpty());
	_range_invalid(szUserName.isEmpty());
	_range_invalid(szAddress.isEmpty());
	switch(type){
		case 0: //Nick!User@foo.foobar.com
			szMask.sprintf("%s!%s@%s",szNick.data(),szUserName.data(),szAddress.data());
			break;
		case 1: //User@foo.fobar.com
			szMask.sprintf("%s@%s",szUserName.data(),szAddress.data());
			break;
		case 2: //Nick!*@foo.foobar.com
			szMask.sprintf("%s!*@%s",szNick.data(),szAddress.data());
			break;
		case 3: //*!User@foo.foobar.com
			szMask.sprintf("*!%s@%s",szUserName.data(),szAddress.data());
			break;
		case 4: //Nick!*@*
			szMask.sprintf("%s!*@*",szNick.data());
			break;
		case 5: //*!*@*.foobar.com or *!*@255.255.255.*
			szMask="*!*@";
			{
				const char *pC=szAddress.data();
				bool bIp=true;
				while(*pC && bIp){
					if(*pC=='.' || ((*pC>='0')&&(*pC<='9')) )pC++;
					else bIp=false;
				}
				if(bIp){
					int idx=szAddress.findRev('.');
					szMask+=szAddress.left(idx);
					szMask+=".*";
				} else {
					szMask+="*";
					pC=szAddress.data();
					while((*pC) && (!(*pC=='.')))pC++;
					szMask+=QString(pC);
				}
			}
			break;
		case 6: //*!user@*.foobar.com or *!user@255.255.255.*
			szMask="*!";
			szMask+=szUserName.data();
			szMask+='@';
			{
				const char *pC=szAddress.data();
				bool bIp=true;
				while(*pC && bIp){
					if(*pC=='.' || ((*pC>='0')&&(*pC<='9')) )pC++;
					else bIp=false;
				}
				if(bIp){
					int idx=szAddress.findRev('.');
					szMask+=szAddress.left(idx);
					szMask+=".*";
				} else {
					szMask+="*";
					pC=szAddress.data();
					while((*pC) && (!(*pC=='.')))pC++;
					szMask+=QString(pC);
				}
			}
			break;
		case 7: //nick!user@*.foobar.com or nick!user@255.255.255.*
			szMask=szNick.data();
			szMask+='!';
			szMask+=szUserName.data();
			szMask+='@';
			{
				const char *pC=szAddress.data();
				bool bIp=true;
				while(*pC && bIp){
					if(*pC=='.' || ((*pC>='0')&&(*pC<='9')) )pC++;
					else bIp=false;
				}
				if(bIp){
					int idx=szAddress.findRev('.');
					szMask+=szAddress.left(idx);
					szMask+=".*";
				} else {
					szMask+="*";
					pC=szAddress.data();
					while((*pC) && (!(*pC=='.')))pC++;
					szMask+=QString(pC);
				}
			}
			break;	
		case 8: //nick!*@*.foobar.com or nick!*@255.255.255.*
			szMask=szNick.data();
			szMask+="!*@";
			{
				const char *pC=szAddress.data();
				bool bIp=true;
				while(*pC && bIp){
					if(*pC=='.' || ((*pC>='0')&&(*pC<='9')) )pC++;
					else bIp=false;
				}
				if(bIp){
					int idx=szAddress.findRev('.');
					szMask+=szAddress.left(idx);
					szMask+=".*";
				} else {
					szMask+="*";
					pC=szAddress.data();
					while((*pC) && (!(*pC=='.')))pC++;
					szMask+=QString(pC);
				}
			}
			break;		
		default:
			szMask.sprintf("%s!%s@%s",szNick.data(),szUserName.data(),szAddress.data());
			break;	
	}
	_debug_leavetrace("mask");
}
bool KviNewNick::matches(QString &szMask)
{
	int idx=szMask.find('!');
	if(idx == -1){ //it's only a nick...
		QString szM=szMask.stripWhiteSpace();
		if(szM[0]=='@' || szM[0]=='+')szM.remove(0,1);
		QString szm=szMask.lower();
		QString szn=szNick.lower();
		return (szm==szn);
	}
	QRegExp rMask((szMask.lower()).data(),false,true);
	QString szTmpM;
	mask(szTmpM);
	QRegExp myMask((szTmpM.lower()).data(),false,true);
	if(rMask.match(myMask.pattern()) != -1)return true;
	return (myMask.match(rMask.pattern()) != -1);
	
}
bool KviNewNick::matches(const char *szMask)
{
	QString szTheMask(szMask);
	return matches(szTheMask);
}

//
// $Log:...$
//
