//   $Id: kvi_netscape.h,v 1.2 1998/09/20 20:23:16 fritz Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_NETSCAPE_H_INCLUDED_
#define _KVI_NETSCAPE_H_INCLUDED_

#include <qstring.h>

#include <X11/Xlib.h>

class KviNetscapeController {
public:
	KviNetscapeController();
	~KviNetscapeController();
public:
	bool openURL(const char *url);
};

class KviNetscapeRemote {
public:
	KviNetscapeRemote();
	~KviNetscapeRemote();
protected:
	Atom XA_MOZILLA_VERSION;
	Atom XA_MOZILLA_LOCK;
	Atom XA_MOZILLA_COMMAND;
	Atom XA_MOZILLA_RESPONSE;
	QString lock_data;
	Window window;
	bool m_bInitSuccess;
	bool m_bUsed;
public:
	bool initialize();
	bool executeCommand(const char *command);
protected:
	void mozillaRemoteInitAtoms();
	Window mozillaRemoteFindWindow();
	bool mozillaRemoteObtainLock();
	void mozillaRemoteFreeLock();
	int mozillaRemoteCommand(const char *command);
	Window my_XmuClientWindow(Display *dpy,Window win);
	Window my_XmuClientWindowTryChildren(Display *dpy,Window win,Atom WM_STATE);
};

#endif //_KVI_NETSCAPE_H_INCLUDED_
