//   $Id: kvi_mdi.h,v 1.2 1998/10/24 13:21:12 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#ifndef _KVI_MDI_H_INCLUDED_
#define _KVI_MDI_H_INCLUDED_

#include "kvi_child.h"

#include <qframe.h>
#include <qlist.h>

class KviNewTaskBar;

class KviMdiManager : public QFrame
{
	friend class KviMdiChild;
	friend class KviNewTaskBar;
	Q_OBJECT;
public:		//Construction & Destruction
	KviMdiManager(KviFrame *parent);
	~KviMdiManager();
public:		//member variables
	KviFrame			*m_lpFrm;
	KviInterface		*m_lpInt;
	QList<KviMdiChild>	*m_lpChildList;
	KviNewTaskBar       *m_lpTaskBar;
	QPopupMenu			*m_lpWinListPopup;

	bool				m_bMinimizingAll;

public:		//methods
	void applyOptions();
	void linkChildren(QWidget *widget,QWidget *focusedOne);
	void addChild(KviMdiChild *lpC,bool setGeom=true);
	void addChildMinimized(KviMdiChild *lpC,bool setGeom=true);
	KviMdiChild * topChildInZOrder();
	void childFocusIn(KviMdiChild *lpC);
	void childFocusOut(KviMdiChild *);
	void focusTopChild();
	KviMdiChild * findWindow(const char *szName);
	KviMdiChild * findWindow(const QString &szName);
	KviMdiChild * findWindow(int winId);
	void removeWindow(const char *szName);
	void removeWindow(int winId);
	void removeWindow(KviMdiChild *lpC);
	int getVisibleChildCount();
public slots:
	void highlightWindow(int nID);
	void fillWinListPopup();
	void focusNextChild();
	void taskbarButtonClicked(int nId,bool bIsOn);
	void menuButtonClicked(int nId);
	void taskbarPopupRequest(QPoint pnt,int nId);
	void childMaximized(KviMdiChild *lpC);
	void childMinimized(KviMdiChild *lpC);
	void minimizeAllWindows();
	void restoreAllWindows();
	void cascadeWindows();
	void tileHorz();
	void tileVert();
	void tilePragma();
	void tileAnodine();
protected:
	virtual void focusInEvent(QFocusEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
	bool eventFilter(QObject *ob,QEvent *e);
private:
	void tileAllInternal(int maxWnds);
	void drawDragRectangle(QRect &rectToDraw,int style=0);
};

#endif // _KVI_MDI_H_INCLUDED_
