//   $Id: kvi_listbox.h,v 1.3 1998/09/25 15:58:32 pragma Exp $
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program; see the file COPYING.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//
#ifndef _KVI_LISTBOX_H_INCLUDED_
#define _KVI_LISTBOX_H_INCLUDED_

#include "kvi_nick.h"
#include "kvi_types.h"
#include <qframe.h>
#include <qlist.h>
#include <qscrollbar.h>

class KviMdiChild;
class KviFrame;
class KviInterface;
class KviGlobalUserList;

class KviListBox : public QFrame{
	Q_OBJECT;
public:
	KviListBox(QWidget *parent,KviMdiChild *mdiParent,KviFrame *frame,const char *name=0);
	~KviListBox();
public:
	QScrollBar             *m_lpScrollBar;
	KviGlobalUserList      *m_lpGUList;
	KviMdiChild            *m_lpMdiParent;
	KviFrame               *m_lpFrm;
	KviInterface           *m_lpInt;
	QList<KviListBoxEntry> *m_lpNickList;
	QPixmap                *m_lpMemBuffer;
	QPainter               *m_lpPainter;
	QPixmap                *m_lpOpPixmap;
	QPixmap                *m_lpVoicePixmap;
	uint                    m_iOp;
	uint                    m_iVoice;
	uint                    m_iTotal;
	bool                    m_bAutoUpdate;
	int                     m_iOffset;
	int                     m_iCellHeight;
	int                     m_iLastUnderCursor;
public:
	void clearList();
	void removeAll();
	void clearSelection();
	KviListBoxEntry *findEntry(const char *szNick);
	KviListBoxEntry *getEntryAt(uint index);
	void insertEntry(KviListBoxEntry *lpE);
	void nickJoin(KviNewNick &kn,bool bIsOp=false,bool bIsVoice=false);
	bool resortNick(KviNewNick *lpGlobalNickPointer);
	KviListBoxEntry *getEntryByPointer(KviNewNick *lpGlobalNickPointer);
	void nickPart(const char *szNick);
	void opNick(const char *szNick,bool bOp=true);
	void voiceNick(const char *szNick,bool bVoice=true);
	bool isOp(const char *szNick);
	bool isVoice(const char *szNick);
protected:
	void infoToStatus(KviNewNick *lpN);
	void updateCellSize();
	void updateScrollBar();
	virtual void resizeEvent(QResizeEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
	virtual void drawContents(QPainter *p);
protected slots:
	void scrollBarMoved(int value);
public:
	virtual void setFont(const QFont &font);
};

#endif //_KVI_LISTBOX_H_INCLUDED_
