//   $Id: kvi_intdlg.cpp,v 1.4 1998/09/28 13:03:07 pragma Exp $
//
//   This file is part of the KVIrc+ irc client distribution
//   Copyright (C) 1998 Szymon Stefanek (stefanek@tin.it)
//
//   This program is free software; you can redistribute it and/or
//   modify it under the terms of the GNU General Public
//   License as published by the Free Software Foundation; either
//   version 2 of the License, or (at your option) any later version.
//
//   This program is distributed in the hope that it will be useful,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
//   Library General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this library; see the file COPYING.LIB.  If not, write to
//   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
//   Boston, MA 02111-1307, USA.
//

#include "kvi_intdlg.h"
#include "kvi_frame.h"
#include "kvi_debug.h"
#include "kvi_app.h"
#include "kvi_int.h"
#include "kvi_chng.h"

#include <qlayout.h>

//============ KviInterfaceDialog ============//

KviInterfaceDialog::KviInterfaceDialog(KviFrame *lpParent,KviInterface *lpInt):QTabDialog(lpParent,"KviInterfaceDialogClass",true)
{
	_debug_entertrace("KviInterfaceDialog");
	m_lpInt=lpInt;

	setCaption(i18n("User interface settings"));
	//New tabs, using layouts

	//main tab
	QWidget *tab=new QWidget(this);
	QGridLayout *l=new QGridLayout(tab,3,1,10,4);
	KviNewColorChanger *c=new KviNewColorChanger(this,tab,i18n("Background color"),&(m_lpInt->clr_bk_mdi));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	KviNewPixmapChanger *p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_mdi),
								&(m_lpInt->pix_bk_mdi));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,1,0);

	QLabel *lb=new QLabel(i18n("Please be careful to select a 'real' image.\n"\
						"A 'buggy' image can hang kvirc.\n"\
						"If it happens,and kvirc refuses to restart,\n"\
						"please delete the kvircrc file in the\n"\
						"$HOME/.kde/share/config/ directory"),tab);
	lb->adjustSize();
	lb->setMinimumSize(lb->size());
	l->addWidget(lb,2,0);

	l->activate();
	addTab(tab,i18n("&Main"));

	//input tab
	tab=new QWidget(this);
	l=new QGridLayout(tab,7,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Background"),&(m_lpInt->clr_bk_input));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Foreground"),&(m_lpInt->clr_fr_input));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection background color"),&(m_lpInt->clr_bk_sel_input));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection foreground"),&(m_lpInt->clr_fr_sel_input));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,3,0);

	c=new KviNewColorChanger(this,tab,i18n("Cursor & control marks"),&(m_lpInt->clr_cursor_input));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,4,0);

	KviNewFontChanger *f=new KviNewFontChanger(this,tab,i18n("Font"),&(m_lpInt->fnt_input));
	f->adjustSize();
	f->setMinimumSize(f->size());
	l->addWidget(f,5,0);

	p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_input),
								&(m_lpInt->pix_bk_input));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,6,0);	

	l->activate();
	addTab(tab,i18n("&Input"));

	//Output tab
	tab=new QWidget(this);
	l=new QGridLayout(tab,5,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Background"),&(m_lpInt->clr_bk_output));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection foreground"),&(m_lpInt->clr_fr_sel_output));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection background color"),&(m_lpInt->clr_bk_sel_output));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	f=new KviNewFontChanger(this,tab,i18n("Font"),&(m_lpInt->fnt_output));
	f->adjustSize();
	f->setMinimumSize(f->size());
	l->addWidget(f,3,0);

	p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_output),
								&(m_lpInt->pix_bk_output));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,4,0);	

	l->activate();
	addTab(tab,i18n("&Output"));

	//Labels tab
	tab=new QWidget(this);
	l=new QGridLayout(tab,5,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Background"),&(m_lpInt->clr_bk_chanlabels));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Disabled foreground"),&(m_lpInt->clr_fr_chanlabels));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Enabled foreground"),&(m_lpInt->clr_fr_act_chanlabels));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	f=new KviNewFontChanger(this,tab,i18n("Font"),&(m_lpInt->fnt_chanlabels));
	f->adjustSize();
	f->setMinimumSize(f->size());
	l->addWidget(f,3,0);

	p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_chanlabels),
								&(m_lpInt->pix_bk_chanlabels));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,4,0);	

	l->activate();
	addTab(tab,i18n("&Labels"));

	//Nick list
	tab=new QWidget(this);
	l=new QGridLayout(tab,8,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Background"),&(m_lpInt->clr_bk_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Foreground"),&(m_lpInt->clr_fr_normal_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection background"),&(m_lpInt->clr_bk_sel_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	c=new KviNewColorChanger(this,tab,i18n("Selection foreground"),&(m_lpInt->clr_fr_sel_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,3,0);

	c=new KviNewColorChanger(this,tab,i18n("Op foreground"),&(m_lpInt->clr_fr_op_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,4,0);

	c=new KviNewColorChanger(this,tab,i18n("Voice foreground"),&(m_lpInt->clr_fr_voice_listbox));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,5,0);

	f=new KviNewFontChanger(this,tab,i18n("Font"),&(m_lpInt->fnt_listbox));
	f->adjustSize();
	f->setMinimumSize(f->size());
	l->addWidget(f,6,0);

	p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_listbox),
								&(m_lpInt->pix_bk_listbox));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,7,0);	

	l->activate();
	addTab(tab,i18n("&Nick list"));

	//Captions tab
	tab=new QWidget(this);
	l=new QGridLayout(tab,6,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Active background"),&(m_lpInt->clr_bk_act_caption));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Active foreground"),&(m_lpInt->clr_fr_act_caption));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Inactive background"),&(m_lpInt->clr_bk_ina_caption));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	c=new KviNewColorChanger(this,tab,i18n("Inactive foreground"),&(m_lpInt->clr_fr_ina_caption));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,3,0);

	f=new KviNewFontChanger(this,tab,i18n("Font"),&(m_lpInt->fnt_caption));
	f->adjustSize();
	f->setMinimumSize(f->size());
	l->addWidget(f,4,0);

	p=new KviNewPixmapChanger(this,tab,i18n("Background image"),&(m_lpInt->str_bk_caption),
								&(m_lpInt->pix_bk_caption));
	p->adjustSize();
	p->setMinimumSize(p->size());
	l->addWidget(p,5,0);	

	l->activate();
	addTab(tab,i18n("&MDI Captions"));

	//script editor tab
	tab=new QWidget(this);

	l=new QGridLayout(tab,9,1,10,4);

	c=new KviNewColorChanger(this,tab,i18n("Background"),&(m_lpInt->clr_edit_back));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,0,0);

	c=new KviNewColorChanger(this,tab,i18n("Default foreground"),&(m_lpInt->clr_edit_fore));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,1,0);

	c=new KviNewColorChanger(this,tab,i18n("Cursor"),&(m_lpInt->clr_edit_cursor));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,2,0);

	c=new KviNewColorChanger(this,tab,i18n("Comments"),&(m_lpInt->clr_edit_comment));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,3,0);

	c=new KviNewColorChanger(this,tab,i18n("Commands"),&(m_lpInt->clr_edit_command));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,4,0);

	c=new KviNewColorChanger(this,tab,i18n("Variables"),&(m_lpInt->clr_edit_variable));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,5,0);

	c=new KviNewColorChanger(this,tab,i18n("Braces"),&(m_lpInt->clr_edit_brace));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,6,0);

	c=new KviNewColorChanger(this,tab,i18n("Operators"),&(m_lpInt->clr_edit_operator));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,7,0);

	c=new KviNewColorChanger(this,tab,i18n("&Channels"),&(m_lpInt->clr_edit_channel));
	c->adjustSize();
	c->setMinimumSize(c->size());
	l->addWidget(c,8,0);

	l->activate();

	addTab(tab,i18n("&Script editor"));

	setCancelButton();
	setDefaultButton("Help");
	connect(this,SIGNAL(defaultButtonPressed()),this,SLOT(invokeHelp()));
	_debug_leavetrace("KviInterfaceDialog");
}

//============ ~KviInterfaceDialog ============//

KviInterfaceDialog::~KviInterfaceDialog()
{
	_debug_entertrace("~KviInterfaceDialog");
	_debug_leavetrace("~KviInterfaceDialog");
}

//============ invokeHelp ============//

void KviInterfaceDialog::invokeHelp()
{
	_debug_entertrace("invokeHelp");
	_debug_leavetrace("invokeHelp");
}


#include "m_kvi_intdlg.moc"
